/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.RuntimeField;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class BaseQueryBuilder<Q extends BaseQuery, SELF extends BaseQueryBuilder<Q, SELF>> {
    @Nullable
    private Sort sort;
    @Nullable
    private Pageable pageable;
    private final List<String> fields = new ArrayList<String>();
    @Nullable
    private List<String> storedFields;
    @Nullable
    private SourceFilter sourceFilter;
    private float minScore;
    private final Collection<String> ids = new ArrayList<String>();
    @Nullable
    private String route;
    protected Query.SearchType searchType = Query.SearchType.QUERY_THEN_FETCH;
    @Nullable
    protected IndicesOptions indicesOptions;
    private boolean trackScores;
    @Nullable
    private String preference;
    @Nullable
    private Integer maxResults;
    @Nullable
    protected HighlightQuery highlightQuery;
    @Nullable
    private Boolean trackTotalHits;
    @Nullable
    protected Integer trackTotalHitsUpTo;
    @Nullable
    protected Duration scrollTime;
    @Nullable
    protected Duration timeout;
    boolean explain = false;
    @Nullable
    protected List<Object> searchAfter;
    @Nullable
    private List<IndexBoost> indicesBoost;
    protected final List<RescorerQuery> rescorerQueries = new ArrayList<RescorerQuery>();
    @Nullable
    protected Boolean requestCache;
    protected final List<Query.IdWithRouting> idsWithRouting = new ArrayList<Query.IdWithRouting>();
    protected final List<RuntimeField> runtimeFields = new ArrayList<RuntimeField>();
    @Nullable
    protected Query.PointInTime pointInTime;

    @Nullable
    public Sort getSort() {
        return this.sort;
    }

    @Nullable
    public Pageable getPageable() {
        return this.pageable;
    }

    public List<String> getFields() {
        return this.fields;
    }

    @Nullable
    public List<String> getStoredFields() {
        return this.storedFields;
    }

    @Nullable
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @Nullable
    public Collection<String> getIds() {
        return this.ids;
    }

    public boolean getTrackScores() {
        return this.trackScores;
    }

    @Nullable
    public IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public float getMinScore() {
        return this.minScore;
    }

    @Nullable
    public String getPreference() {
        return this.preference;
    }

    @Nullable
    public SourceFilter getSourceFilter() {
        return this.sourceFilter;
    }

    @Nullable
    public HighlightQuery getHighlightQuery() {
        return this.highlightQuery;
    }

    @Nullable
    public String getRoute() {
        return this.route;
    }

    @Nullable
    public List<IndexBoost> getIndicesBoost() {
        return this.indicesBoost;
    }

    public Query.SearchType getSearchType() {
        return this.searchType;
    }

    @Nullable
    public Boolean getTrackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public Integer getTrackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    @Nullable
    public Duration getScrollTime() {
        return this.scrollTime;
    }

    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    public boolean getExplain() {
        return this.explain;
    }

    @Nullable
    public List<Object> getSearchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public Boolean getRequestCache() {
        return this.requestCache;
    }

    public List<Query.IdWithRouting> getIdsWithRouting() {
        return this.idsWithRouting;
    }

    public List<RuntimeField> getRuntimeFields() {
        return this.runtimeFields;
    }

    public List<RescorerQuery> getRescorerQueries() {
        return this.rescorerQueries;
    }

    @Nullable
    public Query.PointInTime getPointInTime() {
        return this.pointInTime;
    }

    public SELF withPageable(Pageable pageable) {
        this.pageable = pageable;
        return this.self();
    }

    public SELF withSort(Sort sort) {
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return this.self();
    }

    public SELF withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this.self();
    }

    public SELF withIds(String ... ids) {
        this.ids.clear();
        this.ids.addAll(Arrays.asList(ids));
        return this.self();
    }

    public SELF withIds(Collection<String> ids) {
        Assert.notNull(ids, (String)"ids must not be null");
        this.ids.clear();
        this.ids.addAll(ids);
        return this.self();
    }

    public SELF withTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this.self();
    }

    public SELF withIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this.self();
    }

    public SELF withMinScore(float minScore) {
        this.minScore = minScore;
        return this.self();
    }

    public SELF withPreference(String preference) {
        this.preference = preference;
        return this.self();
    }

    public SELF withSourceFilter(SourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
        return this.self();
    }

    public SELF withFields(String ... fields) {
        this.fields.clear();
        Collections.addAll(this.fields, fields);
        return this.self();
    }

    public SELF withFields(Collection<String> fields) {
        Assert.notNull(fields, (String)"fields must not be null");
        this.fields.clear();
        this.fields.addAll(fields);
        return this.self();
    }

    public SELF withHighlightQuery(HighlightQuery highlightQuery) {
        this.highlightQuery = highlightQuery;
        return this.self();
    }

    public SELF withRoute(String route) {
        this.route = route;
        return this.self();
    }

    public SELF withIndicesBoost(@Nullable List<IndexBoost> indicesBoost) {
        this.indicesBoost = indicesBoost;
        return this.self();
    }

    public SELF withStoredFields(@Nullable List<String> storedFields) {
        this.storedFields = storedFields;
        return this.self();
    }

    public SELF withIndicesBoost(IndexBoost ... indicesBoost) {
        this.indicesBoost = Arrays.asList(indicesBoost);
        return this.self();
    }

    public SELF withSearchType(Query.SearchType searchType) {
        this.searchType = searchType;
        return this.self();
    }

    public SELF withTrackTotalHits(@Nullable Boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
        return this.self();
    }

    public SELF withTrackTotalHitsUpTo(@Nullable Integer trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        return this.self();
    }

    public SELF withTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
        return this.self();
    }

    public SELF withScrollTime(@Nullable Duration scrollTime) {
        this.scrollTime = scrollTime;
        return this.self();
    }

    public SELF withExplain(boolean explain) {
        this.explain = explain;
        return this.self();
    }

    public SELF withSearchAfter(@Nullable List<Object> searchAfter) {
        this.searchAfter = searchAfter;
        return this.self();
    }

    public SELF withRequestCache(@Nullable Boolean requestCache) {
        this.requestCache = requestCache;
        return this.self();
    }

    public SELF withIdsWithRouting(List<Query.IdWithRouting> idsWithRouting) {
        Assert.notNull(idsWithRouting, (String)"idsWithRouting must not be null");
        this.idsWithRouting.clear();
        this.idsWithRouting.addAll(idsWithRouting);
        return this.self();
    }

    public SELF withRuntimeFields(List<RuntimeField> runtimeFields) {
        Assert.notNull(runtimeFields, (String)"runtimeFields must not be null");
        this.runtimeFields.clear();
        this.runtimeFields.addAll(runtimeFields);
        return this.self();
    }

    public SELF withRescorerQueries(List<RescorerQuery> rescorerQueries) {
        Assert.notNull(rescorerQueries, (String)"rescorerQueries must not be null");
        this.rescorerQueries.clear();
        this.rescorerQueries.addAll(rescorerQueries);
        return this.self();
    }

    public SELF withRescorerQuery(RescorerQuery rescorerQuery) {
        Assert.notNull((Object)rescorerQuery, (String)"rescorerQuery must not be null");
        this.rescorerQueries.add(rescorerQuery);
        return this.self();
    }

    public SELF withPointInTime(@Nullable Query.PointInTime pointInTime) {
        this.pointInTime = pointInTime;
        return this.self();
    }

    public abstract Q build();

    private SELF self() {
        return (SELF)this;
    }
}

