/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.erhlc;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.client.erhlc.RequestFactory;
import org.springframework.data.elasticsearch.client.erhlc.ResponseConverter;
import org.springframework.data.elasticsearch.core.IndexInformation;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ReactiveIndexOperations;
import org.springframework.data.elasticsearch.core.ReactiveResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.AliasData;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.GetTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ReactiveMappingBuilder;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.data.elasticsearch.core.index.TemplateData;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
class ReactiveIndexTemplate
implements ReactiveIndexOperations {
    private static final Log LOGGER = LogFactory.getLog(ReactiveIndexTemplate.class);
    @Nullable
    private final Class<?> boundClass;
    private final IndexCoordinates boundIndex;
    private final RequestFactory requestFactory;
    private final ReactiveElasticsearchOperations operations;
    private final ElasticsearchConverter converter;

    public ReactiveIndexTemplate(ReactiveElasticsearchOperations operations, IndexCoordinates index) {
        Assert.notNull((Object)operations, (String)"operations must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        this.operations = operations;
        this.converter = operations.getElasticsearchConverter();
        this.requestFactory = new RequestFactory(operations.getElasticsearchConverter());
        this.boundClass = null;
        this.boundIndex = index;
    }

    public ReactiveIndexTemplate(ReactiveElasticsearchOperations operations, Class<?> clazz) {
        Assert.notNull((Object)operations, (String)"operations must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        this.operations = operations;
        this.converter = operations.getElasticsearchConverter();
        this.requestFactory = new RequestFactory(operations.getElasticsearchConverter());
        this.boundClass = clazz;
        this.boundIndex = this.getIndexCoordinatesFor(clazz);
    }

    @Override
    public Mono<Boolean> create() {
        IndexCoordinates index = this.getIndexCoordinates();
        if (this.boundClass != null) {
            return this.createSettings(this.boundClass).flatMap(settings -> this.doCreate(index, (Map<String, Object>)settings, null));
        }
        return this.doCreate(index, new Settings(), null);
    }

    @Override
    public Mono<Boolean> createWithMapping() {
        return this.createSettings().flatMap(settings -> this.createMapping().flatMap(mapping -> this.doCreate(this.getIndexCoordinates(), (Map<String, Object>)settings, (Document)mapping)));
    }

    @Override
    public Mono<Boolean> create(Map<String, Object> settings) {
        Assert.notNull(settings, (String)"settings must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, null);
    }

    @Override
    public Mono<Boolean> create(Map<String, Object> settings, Document mapping) {
        Assert.notNull(settings, (String)"settings must not be null");
        Assert.notNull((Object)mapping, (String)"mapping must not be null");
        return this.doCreate(this.getIndexCoordinates(), settings, mapping);
    }

    private Mono<Boolean> doCreate(IndexCoordinates index, Map<String, Object> settings, @Nullable Document mapping) {
        CreateIndexRequest request = this.requestFactory.createIndexRequest(index, settings, mapping);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.createIndex(request)));
    }

    @Override
    public Mono<Boolean> delete() {
        return this.exists().flatMap(exists -> {
            if (exists.booleanValue()) {
                DeleteIndexRequest request = this.requestFactory.deleteIndexRequest(this.getIndexCoordinates());
                return Mono.from(this.operations.executeWithIndicesClient(client -> client.deleteIndex(request))).onErrorResume(NoSuchIndexException.class, e -> Mono.just((Object)false));
            }
            return Mono.just((Object)false);
        });
    }

    @Override
    public Mono<Boolean> exists() {
        GetIndexRequest request = this.requestFactory.getIndexRequest(this.getIndexCoordinates());
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.existsIndex(request)));
    }

    @Override
    public Mono<Void> refresh() {
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.refreshIndex(Requests.refreshRequest((String[])this.getIndexCoordinates().getIndexNames()))));
    }

    @Override
    public Mono<Document> createMapping() {
        return this.createMapping(this.checkForBoundClass());
    }

    @Override
    public Mono<Document> createMapping(Class<?> clazz) {
        String mappingPath;
        Mapping mappingAnnotation = (Mapping)AnnotatedElementUtils.findMergedAnnotation(clazz, Mapping.class);
        if (mappingAnnotation != null && StringUtils.hasText((String)(mappingPath = mappingAnnotation.mappingPath()))) {
            return ReactiveResourceUtil.loadDocument(mappingAnnotation.mappingPath(), "@Mapping");
        }
        return new ReactiveMappingBuilder(this.converter).buildReactivePropertyMapping(clazz).map(Document::parse);
    }

    @Override
    public Mono<Boolean> putMapping(Mono<Document> mapping) {
        return mapping.map(document -> this.requestFactory.putMappingRequest(this.getIndexCoordinates(), (Document)document)).flatMap(request -> Mono.from(this.operations.executeWithIndicesClient(client -> client.putMapping((PutMappingRequest)request))));
    }

    @Override
    public Mono<Document> getMapping() {
        IndexCoordinates indexCoordinates = this.getIndexCoordinates();
        GetMappingsRequest request = this.requestFactory.getMappingsRequest(indexCoordinates);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.getMapping(request))).flatMap(getMappingsResponse -> {
            Map source = ((MappingMetadata)getMappingsResponse.mappings().get(indexCoordinates.getIndexName())).getSourceAsMap();
            Document document = Document.from(source);
            return Mono.just((Object)document);
        });
    }

    @Override
    public Mono<Settings> createSettings() {
        return this.createSettings(this.checkForBoundClass());
    }

    @Override
    public Mono<Settings> createSettings(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        ElasticsearchPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(clazz);
        String settingPath = persistentEntity.settingPath();
        return StringUtils.hasText((String)settingPath) ? ReactiveResourceUtil.loadDocument(settingPath, "@Setting").map(Settings::new) : Mono.just((Object)persistentEntity.getDefaultSettings());
    }

    @Override
    public Mono<Settings> getSettings(boolean includeDefaults) {
        String indexName = this.getIndexCoordinates().getIndexName();
        GetSettingsRequest request = this.requestFactory.getSettingsRequest(indexName, includeDefaults);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.getSettings(request))).map(getSettingsResponse -> ResponseConverter.fromSettingsResponse(getSettingsResponse, indexName));
    }

    @Override
    public Mono<Boolean> alias(AliasActions aliasActions) {
        IndicesAliasesRequest request = this.requestFactory.indicesAliasesRequest(aliasActions);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.updateAliases(request)));
    }

    @Override
    public Mono<Map<String, Set<AliasData>>> getAliases(String ... aliasNames) {
        return this.getAliases(aliasNames, (String[])null);
    }

    @Override
    public Mono<Map<String, Set<AliasData>>> getAliasesForIndex(String ... indexNames) {
        return this.getAliases((String[])null, indexNames);
    }

    private Mono<Map<String, Set<AliasData>>> getAliases(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasesRequest getAliasesRequest = this.requestFactory.getAliasesRequest(aliasNames, indexNames);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.getAliases(getAliasesRequest))).map(GetAliasesResponse::getAliases).map(ResponseConverter::aliasDatas);
    }

    @Override
    public Mono<Boolean> putTemplate(PutTemplateRequest putTemplateRequest) {
        Assert.notNull((Object)putTemplateRequest, (String)"putTemplateRequest must not be null");
        PutIndexTemplateRequest putIndexTemplateRequest = this.requestFactory.putIndexTemplateRequest(putTemplateRequest);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.putTemplate(putIndexTemplateRequest)));
    }

    @Override
    public Mono<TemplateData> getTemplate(GetTemplateRequest getTemplateRequest) {
        Assert.notNull((Object)getTemplateRequest, (String)"getTemplateRequest must not be null");
        GetIndexTemplatesRequest getIndexTemplatesRequest = this.requestFactory.getIndexTemplatesRequest(getTemplateRequest);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.getTemplate(getIndexTemplatesRequest))).flatMap(response -> {
            TemplateData templateData;
            if (response != null && (templateData = ResponseConverter.getTemplateData(response, getTemplateRequest.getTemplateName())) != null) {
                return Mono.just((Object)templateData);
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<Boolean> existsTemplate(ExistsTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        IndexTemplatesExistRequest indexTemplatesExistRequest = this.requestFactory.indexTemplatesExistsRequest(existsTemplateRequest);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.existsTemplate(indexTemplatesExistRequest)));
    }

    @Override
    public Mono<Boolean> deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) {
        Assert.notNull((Object)deleteTemplateRequest, (String)"deleteTemplateRequest must not be null");
        DeleteIndexTemplateRequest deleteIndexTemplateRequest = this.requestFactory.deleteIndexTemplateRequest(deleteTemplateRequest);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.deleteTemplate(deleteIndexTemplateRequest)));
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return this.boundClass != null ? this.getIndexCoordinatesFor(this.boundClass) : this.boundIndex;
    }

    @Override
    public Flux<IndexInformation> getInformation(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        GetIndexRequest getIndexRequest = this.requestFactory.getIndexRequest(index);
        return Mono.from(this.operations.executeWithIndicesClient(client -> client.getIndex(getIndexRequest).map(ResponseConverter::getIndexInformations))).flatMapMany(Flux::fromIterable);
    }

    private IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return ((ElasticsearchPersistentEntity)this.operations.getElasticsearchConverter().getMappingContext().getRequiredPersistentEntity(clazz)).getIndexCoordinates();
    }

    private ElasticsearchPersistentEntity<?> getRequiredPersistentEntity(Class<?> clazz) {
        return (ElasticsearchPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    private Class<?> checkForBoundClass() {
        if (this.boundClass == null) {
            throw new InvalidDataAccessApiUsageException("IndexOperations are not bound");
        }
        return this.boundClass;
    }
}

