/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;

public class Order
extends Sort.Order {
    public static final Mode DEFAULT_MODE = Mode.min;
    public static final Sort.NullHandling DEFAULT_NULL_HANDLING = Sort.NullHandling.NATIVE;
    protected final Mode mode;
    @Nullable
    protected final String unmappedType;

    public Order(Sort.Direction direction, String property) {
        this(direction, property, DEFAULT_MODE, null);
    }

    public Order(Sort.Direction direction, String property, Mode mode) {
        this(direction, property, DEFAULT_NULL_HANDLING, mode, null);
    }

    public Order(Sort.Direction direction, String property, @Nullable String unmappedType) {
        this(direction, property, DEFAULT_NULL_HANDLING, DEFAULT_MODE, unmappedType);
    }

    public Order(Sort.Direction direction, String property, Mode mode, @Nullable String unmappedType) {
        this(direction, property, DEFAULT_NULL_HANDLING, mode, unmappedType);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint) {
        this(direction, property, nullHandlingHint, DEFAULT_MODE, null);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint, Mode mode) {
        this(direction, property, nullHandlingHint, mode, null);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint, @Nullable String unmappedType) {
        this(direction, property, nullHandlingHint, DEFAULT_MODE, unmappedType);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint, Mode mode, @Nullable String unmappedType) {
        super(direction, property, nullHandlingHint);
        this.mode = mode;
        this.unmappedType = unmappedType;
    }

    @Nullable
    public String getUnmappedType() {
        return this.unmappedType;
    }

    public Sort.Order with(Sort.Direction direction) {
        return new Order(direction, this.getProperty(), this.getNullHandling(), this.mode, this.unmappedType);
    }

    public Sort.Order withProperty(String property) {
        return new Order(this.getDirection(), property, this.getNullHandling(), this.mode, this.unmappedType);
    }

    public Sort.Order with(Sort.NullHandling nullHandling) {
        return new Order(this.getDirection(), this.getProperty(), nullHandling, this.getMode(), this.unmappedType);
    }

    public Order withUnmappedType(@Nullable String unmappedType) {
        return new Order(this.getDirection(), this.getProperty(), this.getNullHandling(), this.getMode(), unmappedType);
    }

    public Order with(Mode mode) {
        return new Order(this.getDirection(), this.getProperty(), this.getNullHandling(), mode, this.unmappedType);
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        min,
        max,
        median,
        avg;

    }
}

