/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.data.elasticsearch.client.util.ScrollState;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitsIterator;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class StreamQueries {
    static <T> SearchHitsIterator<T> streamResults(final SearchScrollHits<T> searchHits, final Function<String, SearchScrollHits<T>> continueScrollFunction, final Consumer<List<String>> clearScrollConsumer) {
        Assert.notNull(searchHits, (String)"searchHits must not be null.");
        Assert.notNull((Object)searchHits.getScrollId(), (String)"scrollId of searchHits must not be null.");
        Assert.notNull(continueScrollFunction, (String)"continueScrollFunction must not be null.");
        Assert.notNull(clearScrollConsumer, (String)"clearScrollConsumer must not be null.");
        final Aggregations aggregations = searchHits.getAggregations();
        final float maxScore = searchHits.getMaxScore();
        final long totalHits = searchHits.getTotalHits();
        final TotalHitsRelation totalHitsRelation = searchHits.getTotalHitsRelation();
        return new SearchHitsIterator<T>(){
            private volatile Iterator<SearchHit<T>> scrollHits;
            private volatile boolean continueScroll;
            private volatile ScrollState scrollState;
            {
                this.scrollHits = searchHits.iterator();
                this.continueScroll = this.scrollHits.hasNext();
                this.scrollState = new ScrollState(searchHits.getScrollId());
            }

            public void close() {
                try {
                    clearScrollConsumer.accept(this.scrollState.getScrollIds());
                }
                finally {
                    this.scrollHits = null;
                    this.scrollState = null;
                }
            }

            @Override
            @Nullable
            public Aggregations getAggregations() {
                return aggregations;
            }

            @Override
            public float getMaxScore() {
                return maxScore;
            }

            @Override
            public long getTotalHits() {
                return totalHits;
            }

            @Override
            public TotalHitsRelation getTotalHitsRelation() {
                return totalHitsRelation;
            }

            public boolean hasNext() {
                if (!this.continueScroll) {
                    return false;
                }
                if (!this.scrollHits.hasNext()) {
                    SearchScrollHits nextPage = (SearchScrollHits)continueScrollFunction.apply(this.scrollState.getScrollId());
                    this.scrollHits = nextPage.iterator();
                    this.scrollState.updateScrollId(nextPage.getScrollId());
                    this.continueScroll = this.scrollHits.hasNext();
                }
                return this.scrollHits.hasNext();
            }

            public SearchHit<T> next() {
                if (this.hasNext()) {
                    return this.scrollHits.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private StreamQueries() {
    }
}

