/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.CompletionContext;
import org.springframework.data.elasticsearch.annotations.CompletionField;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.DynamicTemplates;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.ResourceUtil;
import org.springframework.data.elasticsearch.core.completion.Completion;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

class MappingBuilder {
    private static final String FIELD_DATA = "fielddata";
    private static final String FIELD_STORE = "store";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_INDEX = "index";
    private static final String FIELD_FORMAT = "format";
    private static final String FIELD_SEARCH_ANALYZER = "search_analyzer";
    private static final String FIELD_INDEX_ANALYZER = "analyzer";
    private static final String FIELD_NORMALIZER = "normalizer";
    private static final String FIELD_PROPERTIES = "properties";
    private static final String FIELD_PARENT = "_parent";
    private static final String FIELD_COPY_TO = "copy_to";
    private static final String FIELD_CONTEXT_NAME = "name";
    private static final String FIELD_CONTEXT_TYPE = "type";
    private static final String FIELD_CONTEXT_PRECISION = "precision";
    private static final String FIELD_DYNAMIC_TEMPLATES = "dynamic_templates";
    private static final String COMPLETION_PRESERVE_SEPARATORS = "preserve_separators";
    private static final String COMPLETION_PRESERVE_POSITION_INCREMENTS = "preserve_position_increments";
    private static final String COMPLETION_MAX_INPUT_LENGTH = "max_input_length";
    private static final String COMPLETION_CONTEXTS = "contexts";
    private static final String TYPE_VALUE_KEYWORD = "keyword";
    private static final String TYPE_VALUE_GEO_POINT = "geo_point";
    private static final String TYPE_VALUE_COMPLETION = "completion";
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchRestTemplate.class);
    private final ElasticsearchConverter elasticsearchConverter;

    MappingBuilder(ElasticsearchConverter elasticsearchConverter) {
        this.elasticsearchConverter = elasticsearchConverter;
    }

    String buildPropertyMapping(Class<?> clazz) throws IOException {
        ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject(entity.getIndexType());
        this.addDynamicTemplatesMapping(builder, entity);
        String parentType = entity.getParentType();
        if (StringUtils.hasText((String)parentType)) {
            builder.startObject(FIELD_PARENT).field("type", parentType).endObject();
        }
        builder.startObject(FIELD_PROPERTIES);
        this.mapEntity(builder, entity, true, "", false, FieldType.Auto, null);
        builder.endObject().endObject().endObject().close();
        return builder.getOutputStream().toString();
    }

    private void mapEntity(XContentBuilder builder, @Nullable ElasticsearchPersistentEntity entity, boolean isRootObject, String nestedObjectFieldName, boolean nestedOrObjectField, FieldType fieldType, @Nullable Field parentFieldAnnotation) throws IOException {
        boolean writeNestedProperties;
        boolean bl = writeNestedProperties = !isRootObject && (this.isAnyPropertyAnnotatedWithField(entity) || nestedOrObjectField);
        if (writeNestedProperties) {
            String type = nestedOrObjectField ? fieldType.toString().toLowerCase() : FieldType.Object.toString().toLowerCase();
            builder.startObject(nestedObjectFieldName).field("type", type);
            if (nestedOrObjectField && FieldType.Nested == fieldType && parentFieldAnnotation != null && parentFieldAnnotation.includeInParent()) {
                builder.field("include_in_parent", parentFieldAnnotation.includeInParent());
            }
            builder.startObject(FIELD_PROPERTIES);
        }
        if (entity != null) {
            entity.doWithProperties(property -> {
                try {
                    if (property.isAnnotationPresent(Transient.class) || this.isInIgnoreFields((ElasticsearchPersistentProperty)property, parentFieldAnnotation)) {
                        return;
                    }
                    this.buildPropertyMapping(builder, isRootObject, (ElasticsearchPersistentProperty)property);
                }
                catch (IOException e) {
                    logger.warn("error mapping property with name {}", (Object)property.getName(), (Object)e);
                }
            });
        }
        if (writeNestedProperties) {
            builder.endObject().endObject();
        }
    }

    private void buildPropertyMapping(XContentBuilder builder, boolean isRootObject, ElasticsearchPersistentProperty property) throws IOException {
        ClassPathResource mappings;
        String mappingPath;
        if (property.isAnnotationPresent(Mapping.class) && !StringUtils.isEmpty((Object)(mappingPath = ((Mapping)property.getRequiredAnnotation(Mapping.class)).mappingPath())) && (mappings = new ClassPathResource(mappingPath)).exists()) {
            builder.rawField(property.getFieldName(), mappings.getInputStream(), XContentType.JSON);
            return;
        }
        boolean isGeoPointProperty = this.isGeoPointProperty(property);
        boolean isCompletionProperty = this.isCompletionProperty(property);
        boolean isNestedOrObjectProperty = this.isNestedOrObjectProperty(property);
        Field fieldAnnotation = (Field)property.findAnnotation(Field.class);
        if (!isGeoPointProperty && !isCompletionProperty && property.isEntity() && this.hasRelevantAnnotation(property)) {
            if (fieldAnnotation == null) {
                return;
            }
            Iterator iterator = property.getPersistentEntityTypes().iterator();
            ElasticsearchPersistentEntity persistentEntity = iterator.hasNext() ? (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity((TypeInformation)iterator.next()) : null;
            this.mapEntity(builder, persistentEntity, false, property.getFieldName(), isNestedOrObjectProperty, fieldAnnotation.type(), fieldAnnotation);
            if (isNestedOrObjectProperty) {
                return;
            }
        }
        MultiField multiField = (MultiField)property.findAnnotation(MultiField.class);
        if (isGeoPointProperty) {
            this.applyGeoPointFieldMapping(builder, property);
            return;
        }
        if (isCompletionProperty) {
            CompletionField completionField = (CompletionField)property.findAnnotation(CompletionField.class);
            this.applyCompletionFieldMapping(builder, property, completionField);
        }
        if (isRootObject && fieldAnnotation != null && property.isIdProperty()) {
            this.applyDefaultIdFieldMapping(builder, property);
        } else if (multiField != null) {
            this.addMultiFieldMapping(builder, property, multiField, isNestedOrObjectProperty);
        } else if (fieldAnnotation != null) {
            this.addSingleFieldMapping(builder, property, fieldAnnotation, isNestedOrObjectProperty);
        }
    }

    private boolean hasRelevantAnnotation(ElasticsearchPersistentProperty property) {
        return property.findAnnotation(Field.class) != null || property.findAnnotation(MultiField.class) != null || property.findAnnotation(GeoPointField.class) != null || property.findAnnotation(CompletionField.class) != null;
    }

    private void applyGeoPointFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property) throws IOException {
        builder.startObject(property.getFieldName()).field("type", TYPE_VALUE_GEO_POINT).endObject();
    }

    private void applyCompletionFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property, @Nullable CompletionField annotation) throws IOException {
        builder.startObject(property.getFieldName());
        builder.field("type", TYPE_VALUE_COMPLETION);
        if (annotation != null) {
            builder.field(COMPLETION_MAX_INPUT_LENGTH, annotation.maxInputLength());
            builder.field(COMPLETION_PRESERVE_POSITION_INCREMENTS, annotation.preservePositionIncrements());
            builder.field(COMPLETION_PRESERVE_SEPARATORS, annotation.preserveSeparators());
            if (!StringUtils.isEmpty((Object)annotation.searchAnalyzer())) {
                builder.field(FIELD_SEARCH_ANALYZER, annotation.searchAnalyzer());
            }
            if (!StringUtils.isEmpty((Object)annotation.analyzer())) {
                builder.field(FIELD_INDEX_ANALYZER, annotation.analyzer());
            }
            if (annotation.contexts().length > 0) {
                builder.startArray(COMPLETION_CONTEXTS);
                for (CompletionContext context : annotation.contexts()) {
                    builder.startObject();
                    builder.field(FIELD_CONTEXT_NAME, context.name());
                    builder.field("type", context.type().name().toLowerCase());
                    if (context.precision().length() > 0) {
                        builder.field(FIELD_CONTEXT_PRECISION, context.precision());
                    }
                    builder.endObject();
                }
                builder.endArray();
            }
        }
        builder.endObject();
    }

    private void applyDefaultIdFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property) throws IOException {
        builder.startObject(property.getFieldName()).field("type", TYPE_VALUE_KEYWORD).field(FIELD_INDEX, true).endObject();
    }

    private void addSingleFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property, Field annotation, boolean nestedOrObjectField) throws IOException {
        builder.startObject(property.getFieldName());
        this.addFieldMappingParameters(builder, annotation, nestedOrObjectField);
        builder.endObject();
    }

    private void addMultiFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property, MultiField annotation, boolean nestedOrObjectField) throws IOException {
        builder.startObject(property.getFieldName());
        this.addFieldMappingParameters(builder, annotation.mainField(), nestedOrObjectField);
        builder.startObject("fields");
        for (InnerField innerField : annotation.otherFields()) {
            builder.startObject(innerField.suffix());
            this.addFieldMappingParameters(builder, innerField, false);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
    }

    private void addFieldMappingParameters(XContentBuilder builder, Object annotation, boolean nestedOrObjectField) throws IOException {
        boolean index = true;
        boolean store = false;
        boolean fielddata = false;
        FieldType type = null;
        DateFormat dateFormat = null;
        String datePattern = null;
        String analyzer = null;
        String searchAnalyzer = null;
        String normalizer = null;
        String[] copyTo = null;
        if (annotation instanceof Field) {
            Field fieldAnnotation = (Field)annotation;
            index = fieldAnnotation.index();
            store = fieldAnnotation.store();
            fielddata = fieldAnnotation.fielddata();
            type = fieldAnnotation.type();
            dateFormat = fieldAnnotation.format();
            datePattern = fieldAnnotation.pattern();
            analyzer = fieldAnnotation.analyzer();
            searchAnalyzer = fieldAnnotation.searchAnalyzer();
            normalizer = fieldAnnotation.normalizer();
            copyTo = fieldAnnotation.copyTo();
        } else if (annotation instanceof InnerField) {
            InnerField fieldAnnotation = (InnerField)annotation;
            index = fieldAnnotation.index();
            store = fieldAnnotation.store();
            fielddata = fieldAnnotation.fielddata();
            type = fieldAnnotation.type();
            dateFormat = fieldAnnotation.format();
            datePattern = fieldAnnotation.pattern();
            analyzer = fieldAnnotation.analyzer();
            searchAnalyzer = fieldAnnotation.searchAnalyzer();
            normalizer = fieldAnnotation.normalizer();
        } else {
            throw new IllegalArgumentException("annotation must be an instance of @Field or @InnerField");
        }
        if (!nestedOrObjectField) {
            builder.field(FIELD_STORE, store);
        }
        if (fielddata) {
            builder.field(FIELD_DATA, fielddata);
        }
        if (type != FieldType.Auto) {
            builder.field("type", type.name().toLowerCase());
            if (type == FieldType.Date && dateFormat != DateFormat.none) {
                builder.field(FIELD_FORMAT, dateFormat == DateFormat.custom ? datePattern : dateFormat.toString());
            }
        }
        if (!index) {
            builder.field(FIELD_INDEX, index);
        }
        if (!StringUtils.isEmpty((Object)analyzer)) {
            builder.field(FIELD_INDEX_ANALYZER, analyzer);
        }
        if (!StringUtils.isEmpty((Object)searchAnalyzer)) {
            builder.field(FIELD_SEARCH_ANALYZER, searchAnalyzer);
        }
        if (!StringUtils.isEmpty((Object)normalizer)) {
            builder.field(FIELD_NORMALIZER, normalizer);
        }
        if (copyTo != null && copyTo.length > 0) {
            builder.field(FIELD_COPY_TO, (Object)copyTo);
        }
    }

    private void addDynamicTemplatesMapping(XContentBuilder builder, ElasticsearchPersistentEntity<?> entity) throws IOException {
        ObjectMapper objectMapper;
        JsonNode jsonNode;
        String jsonString;
        String mappingPath;
        if (entity.isAnnotationPresent(DynamicTemplates.class) && StringUtils.hasText((String)(mappingPath = ((DynamicTemplates)entity.getRequiredAnnotation(DynamicTemplates.class)).mappingPath())) && StringUtils.hasText((String)(jsonString = ResourceUtil.readFileFromClasspath(mappingPath))) && (jsonNode = (objectMapper = new ObjectMapper()).readTree(jsonString).get(FIELD_DYNAMIC_TEMPLATES)) != null && jsonNode.isArray()) {
            String json = objectMapper.writeValueAsString((Object)jsonNode);
            builder.rawField(FIELD_DYNAMIC_TEMPLATES, (InputStream)new ByteArrayInputStream(json.getBytes()), XContentType.JSON);
        }
    }

    private boolean isAnyPropertyAnnotatedWithField(@Nullable ElasticsearchPersistentEntity entity) {
        return entity != null && entity.getPersistentProperty(Field.class) != null;
    }

    private boolean isInIgnoreFields(ElasticsearchPersistentProperty property, @Nullable Field parentFieldAnnotation) {
        if (null != parentFieldAnnotation) {
            String[] ignoreFields = parentFieldAnnotation.ignoreFields();
            return Arrays.asList(ignoreFields).contains(property.getFieldName());
        }
        return false;
    }

    private boolean isNestedOrObjectProperty(ElasticsearchPersistentProperty property) {
        Field fieldAnnotation = (Field)property.findAnnotation(Field.class);
        return fieldAnnotation != null && (FieldType.Nested == fieldAnnotation.type() || FieldType.Object == fieldAnnotation.type());
    }

    private boolean isGeoPointProperty(ElasticsearchPersistentProperty property) {
        return property.getActualType() == GeoPoint.class || property.isAnnotationPresent(GeoPointField.class);
    }

    private boolean isCompletionProperty(ElasticsearchPersistentProperty property) {
        return property.getActualType() == Completion.class;
    }
}

