/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.elasticsearch.core.geo.GeoBox;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.query.Field;
import org.springframework.data.elasticsearch.core.query.SimpleField;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Criteria {
    public static final String WILDCARD = "*";
    public static final String CRITERIA_VALUE_SEPERATOR = " ";
    private static final String OR_OPERATOR = " OR ";
    private static final String AND_OPERATOR = " AND ";
    private Field field;
    private float boost = Float.NaN;
    private boolean negating = false;
    private List<Criteria> criteriaChain = new ArrayList<Criteria>(1);
    private Set<CriteriaEntry> queryCriteria = new LinkedHashSet<CriteriaEntry>();
    private Set<CriteriaEntry> filterCriteria = new LinkedHashSet<CriteriaEntry>();

    public String toString() {
        return "Criteria{field=" + this.field.getName() + ", boost=" + this.boost + ", negating=" + this.negating + ", queryCriteria=" + ObjectUtils.nullSafeToString(this.queryCriteria) + ", filterCriteria=" + ObjectUtils.nullSafeToString(this.filterCriteria) + '}';
    }

    public Criteria() {
    }

    public Criteria(String fieldname) {
        this(new SimpleField(fieldname));
    }

    public Criteria(Field field) {
        Assert.notNull((Object)field, (String)"Field for criteria must not be null");
        Assert.hasText((String)field.getName(), (String)"Field.name for criteria must not be null/empty");
        this.criteriaChain.add(this);
        this.field = field;
    }

    protected Criteria(List<Criteria> criteriaChain, String fieldname) {
        this(criteriaChain, new SimpleField(fieldname));
    }

    protected Criteria(List<Criteria> criteriaChain, Field field) {
        Assert.notNull(criteriaChain, (String)"CriteriaChain must not be null");
        Assert.notNull((Object)field, (String)"Field for criteria must not be null");
        Assert.hasText((String)field.getName(), (String)"Field.name for criteria must not be null/empty");
        this.criteriaChain.addAll(criteriaChain);
        this.criteriaChain.add(this);
        this.field = field;
    }

    public static Criteria where(String field) {
        return Criteria.where(new SimpleField(field));
    }

    public static Criteria where(Field field) {
        return new Criteria(field);
    }

    public Criteria and(Field field) {
        return new Criteria(this.criteriaChain, field);
    }

    public Criteria and(String fieldName) {
        return new Criteria(this.criteriaChain, fieldName);
    }

    public Criteria and(Criteria criteria) {
        this.criteriaChain.add(criteria);
        return this;
    }

    public Criteria and(Criteria ... criterias) {
        this.criteriaChain.addAll(Arrays.asList(criterias));
        return this;
    }

    public Criteria or(Field field) {
        return new OrCriteria(this.criteriaChain, field);
    }

    public Criteria or(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Cannot chain 'null' criteria.");
        OrCriteria orConnectedCritiera = new OrCriteria(this.criteriaChain, criteria.getField());
        orConnectedCritiera.queryCriteria.addAll(criteria.queryCriteria);
        return orConnectedCritiera;
    }

    public Criteria or(String fieldName) {
        return this.or(new SimpleField(fieldName));
    }

    public Criteria is(Object o) {
        this.queryCriteria.add(new CriteriaEntry(OperationKey.EQUALS, o));
        return this;
    }

    public Criteria contains(String s) {
        this.assertNoBlankInWildcardedQuery(s, true, true);
        this.queryCriteria.add(new CriteriaEntry(OperationKey.CONTAINS, s));
        return this;
    }

    public Criteria startsWith(String s) {
        this.assertNoBlankInWildcardedQuery(s, true, false);
        this.queryCriteria.add(new CriteriaEntry(OperationKey.STARTS_WITH, s));
        return this;
    }

    public Criteria endsWith(String s) {
        this.assertNoBlankInWildcardedQuery(s, false, true);
        this.queryCriteria.add(new CriteriaEntry(OperationKey.ENDS_WITH, s));
        return this;
    }

    public Criteria not() {
        this.negating = true;
        return this;
    }

    public Criteria fuzzy(String s) {
        this.queryCriteria.add(new CriteriaEntry(OperationKey.FUZZY, s));
        return this;
    }

    public Criteria expression(String s) {
        this.queryCriteria.add(new CriteriaEntry(OperationKey.EXPRESSION, s));
        return this;
    }

    public Criteria boost(float boost) {
        if (boost < 0.0f) {
            throw new InvalidDataAccessApiUsageException("Boost must not be negative.");
        }
        this.boost = boost;
        return this;
    }

    public Criteria between(Object lowerBound, Object upperBound) {
        if (lowerBound == null && upperBound == null) {
            throw new InvalidDataAccessApiUsageException("Range [* TO *] is not allowed");
        }
        this.queryCriteria.add(new CriteriaEntry(OperationKey.BETWEEN, new Object[]{lowerBound, upperBound}));
        return this;
    }

    public Criteria lessThanEqual(Object upperBound) {
        if (upperBound == null) {
            throw new InvalidDataAccessApiUsageException("UpperBound can't be null");
        }
        this.queryCriteria.add(new CriteriaEntry(OperationKey.LESS_EQUAL, upperBound));
        return this;
    }

    public Criteria lessThan(Object upperBound) {
        if (upperBound == null) {
            throw new InvalidDataAccessApiUsageException("UpperBound can't be null");
        }
        this.queryCriteria.add(new CriteriaEntry(OperationKey.LESS, upperBound));
        return this;
    }

    public Criteria greaterThanEqual(Object lowerBound) {
        if (lowerBound == null) {
            throw new InvalidDataAccessApiUsageException("LowerBound can't be null");
        }
        this.queryCriteria.add(new CriteriaEntry(OperationKey.GREATER_EQUAL, lowerBound));
        return this;
    }

    public Criteria greaterThan(Object lowerBound) {
        if (lowerBound == null) {
            throw new InvalidDataAccessApiUsageException("LowerBound can't be null");
        }
        this.queryCriteria.add(new CriteriaEntry(OperationKey.GREATER, lowerBound));
        return this;
    }

    public Criteria in(Object ... values) {
        return this.in(this.toCollection(values));
    }

    public Criteria in(Iterable<?> values) {
        Assert.notNull(values, (String)"Collection of 'in' values must not be null");
        this.queryCriteria.add(new CriteriaEntry(OperationKey.IN, values));
        return this;
    }

    private List<Object> toCollection(Object ... values) {
        return Arrays.asList(values);
    }

    public Criteria notIn(Object ... values) {
        return this.notIn(this.toCollection(values));
    }

    public Criteria notIn(Iterable<?> values) {
        Assert.notNull(values, (String)"Collection of 'NotIn' values must not be null");
        this.queryCriteria.add(new CriteriaEntry(OperationKey.NOT_IN, values));
        return this;
    }

    public Criteria within(GeoPoint location, String distance) {
        Assert.notNull((Object)location, (String)"Location value for near criteria must not be null");
        Assert.notNull((Object)location, (String)"Distance value for near criteria must not be null");
        this.filterCriteria.add(new CriteriaEntry(OperationKey.WITHIN, new Object[]{location, distance}));
        return this;
    }

    public Criteria within(Point location, Distance distance) {
        Assert.notNull((Object)location, (String)"Location value for near criteria must not be null");
        Assert.notNull((Object)location, (String)"Distance value for near criteria must not be null");
        this.filterCriteria.add(new CriteriaEntry(OperationKey.WITHIN, new Object[]{location, distance}));
        return this;
    }

    public Criteria within(String geoLocation, String distance) {
        Assert.isTrue((!StringUtils.isEmpty((Object)geoLocation) ? 1 : 0) != 0, (String)"geoLocation value must not be null");
        this.filterCriteria.add(new CriteriaEntry(OperationKey.WITHIN, new Object[]{geoLocation, distance}));
        return this;
    }

    public Criteria boundedBy(GeoBox boundingBox) {
        Assert.notNull((Object)boundingBox, (String)"boundingBox value for boundedBy criteria must not be null");
        this.filterCriteria.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{boundingBox}));
        return this;
    }

    public Criteria boundedBy(Box boundingBox) {
        Assert.notNull((Object)boundingBox, (String)"boundingBox value for boundedBy criteria must not be null");
        this.filterCriteria.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{boundingBox.getFirst(), boundingBox.getSecond()}));
        return this;
    }

    public Criteria boundedBy(String topLeftGeohash, String bottomRightGeohash) {
        Assert.isTrue((!StringUtils.isEmpty((Object)topLeftGeohash) ? 1 : 0) != 0, (String)"topLeftGeohash must not be empty");
        Assert.isTrue((!StringUtils.isEmpty((Object)bottomRightGeohash) ? 1 : 0) != 0, (String)"bottomRightGeohash must not be empty");
        this.filterCriteria.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{topLeftGeohash, bottomRightGeohash}));
        return this;
    }

    public Criteria boundedBy(GeoPoint topLeftPoint, GeoPoint bottomRightPoint) {
        Assert.notNull((Object)topLeftPoint, (String)"topLeftPoint must not be null");
        Assert.notNull((Object)bottomRightPoint, (String)"bottomRightPoint must not be null");
        this.filterCriteria.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{topLeftPoint, bottomRightPoint}));
        return this;
    }

    public Criteria boundedBy(Point topLeftPoint, Point bottomRightPoint) {
        Assert.notNull((Object)topLeftPoint, (String)"topLeftPoint must not be null");
        Assert.notNull((Object)bottomRightPoint, (String)"bottomRightPoint must not be null");
        this.filterCriteria.add(new CriteriaEntry(OperationKey.BBOX, new Object[]{GeoPoint.fromPoint(topLeftPoint), GeoPoint.fromPoint(bottomRightPoint)}));
        return this;
    }

    private void assertNoBlankInWildcardedQuery(String searchString, boolean leadingWildcard, boolean trailingWildcard) {
        if (searchString != null && searchString.contains(CRITERIA_VALUE_SEPERATOR)) {
            throw new InvalidDataAccessApiUsageException("Cannot constructQuery '" + (leadingWildcard ? WILDCARD : "") + "\"" + searchString + "\"" + (trailingWildcard ? WILDCARD : "") + "'. Use expression or multiple clauses instead.");
        }
    }

    public Field getField() {
        return this.field;
    }

    public Set<CriteriaEntry> getQueryCriteriaEntries() {
        return Collections.unmodifiableSet(this.queryCriteria);
    }

    public Set<CriteriaEntry> getFilterCriteriaEntries() {
        return Collections.unmodifiableSet(this.filterCriteria);
    }

    public Set<CriteriaEntry> getFilterCriteria() {
        return this.filterCriteria;
    }

    public String getConjunctionOperator() {
        return AND_OPERATOR;
    }

    public List<Criteria> getCriteriaChain() {
        return Collections.unmodifiableList(this.criteriaChain);
    }

    public boolean isNegating() {
        return this.negating;
    }

    public boolean isAnd() {
        return AND_OPERATOR == this.getConjunctionOperator();
    }

    public boolean isOr() {
        return OR_OPERATOR == this.getConjunctionOperator();
    }

    public float getBoost() {
        return this.boost;
    }

    public static class CriteriaEntry {
        private OperationKey key;
        private Object value;

        CriteriaEntry(OperationKey key, Object value) {
            this.key = key;
            this.value = value;
        }

        public OperationKey getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "CriteriaEntry{key=" + (Object)((Object)this.key) + ", value=" + this.value + '}';
        }
    }

    public static enum OperationKey {
        EQUALS,
        CONTAINS,
        STARTS_WITH,
        ENDS_WITH,
        EXPRESSION,
        BETWEEN,
        FUZZY,
        IN,
        NOT_IN,
        WITHIN,
        BBOX,
        NEAR,
        LESS,
        LESS_EQUAL,
        GREATER,
        GREATER_EQUAL;

    }

    static class OrCriteria
    extends Criteria {
        public OrCriteria() {
        }

        public OrCriteria(Field field) {
            super(field);
        }

        public OrCriteria(List<Criteria> criteriaChain, Field field) {
            super(criteriaChain, field);
        }

        public OrCriteria(List<Criteria> criteriaChain, String fieldname) {
            super(criteriaChain, fieldname);
        }

        public OrCriteria(String fieldname) {
            super(fieldname);
        }

        @Override
        public String getConjunctionOperator() {
            return Criteria.OR_OPERATOR;
        }
    }
}

