/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.BasicQuery;
import org.springframework.data.couchbase.repository.support.FetchableFluentQuerySupport;
import org.springframework.data.couchbase.repository.support.QuerydslPredicateExecutorSupport;
import org.springframework.data.couchbase.repository.support.SpringDataCouchbaseQuery;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.Assert;

public class QuerydslCouchbasePredicateExecutor<T>
extends QuerydslPredicateExecutorSupport<T>
implements QuerydslPredicateExecutor<T> {
    private final CouchbaseOperations couchbaseOperations;

    public QuerydslCouchbasePredicateExecutor(CouchbaseEntityInformation<T, ?> entityInformation, CouchbaseOperations couchbaseOperations) {
        this(entityInformation, couchbaseOperations, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE);
    }

    public QuerydslCouchbasePredicateExecutor(CouchbaseEntityInformation<T, ?> entityInformation, CouchbaseOperations couchbaseOperations, EntityPathResolver resolver) {
        super(couchbaseOperations.getConverter(), QuerydslCouchbasePredicateExecutor.pathBuilderFor(resolver.createPath(entityInformation.getJavaType())), entityInformation);
        this.couchbaseOperations = couchbaseOperations;
    }

    public Optional<T> findOne(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        try {
            return Optional.ofNullable(this.createQueryFor(predicate).fetchOne());
        }
        catch (NonUniqueResultException ex) {
            throw new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
    }

    public List<T> findAll(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetch();
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull(orders, (String)"Order specifiers must not be null!");
        return ((SpringDataCouchbaseQuery)this.createQueryFor(predicate).orderBy((OrderSpecifier[])orders)).fetch();
    }

    public List<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        return this.applySorting(this.createQueryFor(predicate), sort).fetch();
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orders) {
        Assert.notNull(orders, (String)"Order specifiers must not be null!");
        return ((SpringDataCouchbaseQuery)this.createQuery().orderBy((OrderSpecifier[])orders)).fetch();
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        SpringDataCouchbaseQuery<T> query = this.createQueryFor(predicate);
        return PageableExecutionUtils.getPage(this.applyPagination(query, pageable).fetch(), (Pageable)pageable, query::fetchCount);
    }

    public long count(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetchCount();
    }

    public boolean exists(Predicate predicate) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        return this.createQueryFor(predicate).fetchCount() > 0L;
    }

    public <S extends T, R> R findBy(Predicate predicate, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull((Object)predicate, (String)"Predicate must not be null!");
        Assert.notNull(queryFunction, (String)"Query function must not be null!");
        return queryFunction.apply(new FluentQuerydsl(predicate, this.typeInformation().getJavaType()));
    }

    private SpringDataCouchbaseQuery<T> createQueryFor(Predicate predicate) {
        return (SpringDataCouchbaseQuery)this.createQuery().where(predicate);
    }

    private SpringDataCouchbaseQuery<T> createQuery() {
        return new SpringDataCouchbaseQuery(this.couchbaseOperations, this.typeInformation().getJavaType());
    }

    private SpringDataCouchbaseQuery<T> applyPagination(SpringDataCouchbaseQuery<T> query, Pageable pageable) {
        if (pageable.isUnpaged()) {
            return query;
        }
        query = (SpringDataCouchbaseQuery)((SpringDataCouchbaseQuery)query.offset(pageable.getOffset())).limit(pageable.getPageSize());
        return this.applySorting(query, pageable.getSort());
    }

    private SpringDataCouchbaseQuery<T> applySorting(SpringDataCouchbaseQuery<T> query, Sort sort) {
        this.toOrderSpecifiers(sort).forEach(query::orderBy);
        return query;
    }

    class FluentQuerydsl<T>
    extends FetchableFluentQuerySupport<Predicate, T> {
        FluentQuerydsl(Predicate predicate, Class<T> resultType) {
            this(predicate, Sort.unsorted(), resultType, Collections.emptyList());
        }

        FluentQuerydsl(Predicate predicate, Sort sort, Class<T> resultType, List<String> fieldsToInclude) {
            super(predicate, sort, resultType, fieldsToInclude);
        }

        protected <R> FluentQuerydsl<R> create(Predicate predicate, Sort sort, Class<R> resultType, List<String> fieldsToInclude) {
            return new FluentQuerydsl<R>(predicate, sort, resultType, fieldsToInclude);
        }

        public FluentQuery.FetchableFluentQuery sortBy(Sort sort) {
            return null;
        }

        public FluentQuery.FetchableFluentQuery project(Collection properties) {
            return null;
        }

        public FluentQuery.FetchableFluentQuery as(Class resultType) {
            return null;
        }

        @Override
        public T oneValue() {
            return this.createQuery().fetchOne();
        }

        @Override
        public T firstValue() {
            return this.createQuery().fetchFirst();
        }

        @Override
        public List<T> all() {
            return this.createQuery().fetch();
        }

        @Override
        public Page<T> page(Pageable pageable) {
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            return this.createQuery().fetchPage(pageable);
        }

        @Override
        public Stream<T> stream() {
            return this.createQuery().stream();
        }

        @Override
        public long count() {
            return this.createQuery().fetchCount();
        }

        @Override
        public boolean exists() {
            return this.count() > 0L;
        }

        private SpringDataCouchbaseQuery<T> createQuery() {
            return (SpringDataCouchbaseQuery)new SpringDataCouchbaseQuery(QuerydslCouchbasePredicateExecutor.this.couchbaseOperations, QuerydslCouchbasePredicateExecutor.this.typeInformation().getJavaType(), this.getResultType(), "collection", this::customize).where((Predicate)this.getPredicate());
        }

        private void customize(BasicQuery query) {
            List<String> fieldsToInclude = this.getFieldsToInclude();
            if (!fieldsToInclude.isEmpty()) {
                HashMap<String, String> fields = new HashMap<String, String>();
                fieldsToInclude.forEach(field -> fields.put((String)field, (String)field));
                query.setProjectionFields(fields);
            }
            if (this.getSort().isSorted()) {
                query.with(this.getSort());
            }
        }
    }
}

