/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.CommonOptions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.data.couchbase.repository.CouchbaseRepository;
import org.springframework.data.couchbase.repository.ReactiveCouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.FindMethod;

public class DynamicInvocationHandler<T>
implements InvocationHandler {
    final T target;
    final Class<?> repositoryClass;
    final CouchbaseEntityInformation<?, String> entityInformation;
    final ReactiveCouchbaseTemplate reactiveTemplate;
    CommonOptions<?> options;
    String collection;
    String scope;

    public DynamicInvocationHandler(T target, CommonOptions<?> options, String collection, String scope) {
        this.target = target;
        if (target instanceof CouchbaseRepository) {
            this.reactiveTemplate = ((CouchbaseTemplate)((CouchbaseRepository)target).getOperations()).reactive();
            this.entityInformation = ((CouchbaseRepository)target).getEntityInformation();
        } else if (target instanceof ReactiveCouchbaseRepository) {
            this.reactiveTemplate = (ReactiveCouchbaseTemplate)((ReactiveCouchbaseRepository)this.target).getOperations();
            this.entityInformation = ((ReactiveCouchbaseRepository)this.target).getEntityInformation();
        } else {
            throw new RuntimeException("Unknown target type: " + target.getClass() + " CouchbaseRepository.class.isAssignable:" + CouchbaseRepository.class.isAssignableFrom(target.getClass()) + " " + this.dumpInterfaces(target.getClass(), "  "));
        }
        this.options = options;
        this.collection = collection;
        this.scope = scope;
        this.repositoryClass = target.getClass();
    }

    String dumpInterfaces(Class clazz, String tab) {
        StringBuffer sb = new StringBuffer();
        sb.append(tab + "{");
        for (Class<?> c : clazz.getInterfaces()) {
            sb.append(tab + "  " + c.getSimpleName());
            if (c.getInterfaces().length <= 0) continue;
            sb.append(this.dumpInterfaces(c, tab + "  "));
        }
        sb.append(tab + "}");
        return sb.toString();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if ("toString".equals(method.getName())) {
            return "proxy -> target:" + this.target;
        }
        if (method.getName().equals("withOptions")) {
            return Proxy.newProxyInstance(this.repositoryClass.getClassLoader(), this.target.getClass().getInterfaces(), new DynamicInvocationHandler<T>(this.target, (CommonOptions)args[0], this.collection, this.scope));
        }
        if (method.getName().equals("withScope")) {
            return Proxy.newProxyInstance(this.repositoryClass.getClassLoader(), this.target.getClass().getInterfaces(), new DynamicInvocationHandler<T>(this.target, this.options, this.collection, (String)args[0]));
        }
        if (method.getName().equals("withCollection")) {
            return Proxy.newProxyInstance(this.repositoryClass.getClassLoader(), this.target.getClass().getInterfaces(), new DynamicInvocationHandler<T>(this.target, this.options, (String)args[0], this.scope));
        }
        Class[] paramTypes = new Class[]{};
        if (args != null) {
            paramTypes = (Class[])Arrays.stream(args).map(o -> o == null ? null : (o.getClass() == this.entityInformation.getJavaType() ? Object.class : o.getClass())).toArray(Class[]::new);
            if (method.getName().endsWith("ById") && args.length == 1 && !Iterable.class.isAssignableFrom(paramTypes[0])) {
                paramTypes[0] = Object.class;
            }
        }
        Method theMethod = FindMethod.findMethod(this.repositoryClass, method.getName(), paramTypes);
        try {
            this.setThreadLocal();
            result = theMethod.invoke(this.target, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        return result;
    }

    private void setThreadLocal() {
        if (this.reactiveTemplate.getPseudoArgs() != null) {
            throw new RuntimeException("pseudoArgs not yet consumed by previous caller");
        }
        this.reactiveTemplate.setPseudoArgs(new PseudoArgs(this.scope, this.collection, this.options));
    }
}

