/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.transaction.TransactionOperationFailedException;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.threadlocal.TransactionMarkerOwner;
import java.util.Optional;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import reactor.core.publisher.Mono;

@Stability.Internal
public class TransactionalSupport {
    public static Mono<Optional<CouchbaseResourceHolder>> checkForTransactionInThreadLocalStorage() {
        return TransactionMarkerOwner.get().flatMap(markerOpt -> {
            Optional out = markerOpt.flatMap(marker -> Optional.of(new CouchbaseResourceHolder(marker.context())));
            return Mono.just(out);
        });
    }

    public static Mono<Void> verifyNotInTransaction(String methodName) {
        return TransactionalSupport.checkForTransactionInThreadLocalStorage().flatMap(s -> {
            if (s.isPresent()) {
                return Mono.error((Throwable)new IllegalArgumentException(methodName + " can not be used inside a transaction"));
            }
            return Mono.empty();
        });
    }

    public static RuntimeException retryTransactionOnCasMismatch(CoreTransactionAttemptContext ctx, long cas1, long cas2) {
        try {
            ctx.logger().info(ctx.attemptId(), "Spring CAS mismatch %s != %s, retrying transaction", new Object[]{cas1, cas2});
            TransactionOperationFailedException err = TransactionOperationFailedException.Builder.createError().retryTransaction().cause((Throwable)new CasMismatchException(null)).build();
            return ctx.operationFailed(err);
        }
        catch (Throwable err) {
            return new RuntimeException(err);
        }
    }
}

