/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.mapping.Expiration;
import org.springframework.data.couchbase.core.mapping.Field;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Lazy;
import org.springframework.util.StringUtils;

public class BasicCouchbasePersistentProperty
extends AnnotationBasedPersistentProperty<CouchbasePersistentProperty>
implements CouchbasePersistentProperty {
    private final FieldNamingStrategy fieldNamingStrategy;
    private String fieldName;
    private final Lazy<Boolean> isExpiration = Lazy.of(() -> this.isAnnotationPresent(Expiration.class));

    public BasicCouchbasePersistentProperty(Property property, CouchbasePersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder, FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.fieldNamingStrategy = fieldNamingStrategy == null ? PropertyNameFieldNamingStrategy.INSTANCE : fieldNamingStrategy;
    }

    protected Association<CouchbasePersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public String getFieldName() {
        JsonProperty annotation;
        if (this.fieldName != null) {
            return this.fieldName;
        }
        Field annotationField = this.getField().getAnnotation(Field.class);
        if (annotationField != null) {
            if (StringUtils.hasText((String)annotationField.value())) {
                this.fieldName = annotationField.value();
                return this.fieldName;
            }
            if (StringUtils.hasText((String)annotationField.name())) {
                this.fieldName = annotationField.name();
                return this.fieldName;
            }
        }
        if ((annotation = this.getField().getAnnotation(JsonProperty.class)) != null && StringUtils.hasText((String)annotation.value())) {
            this.fieldName = annotation.value();
            return this.fieldName;
        }
        String fName = this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
        if (!StringUtils.hasText((String)fName)) {
            throw new MappingException(String.format("Invalid (null or empty) field name returned for property %s by %s!", this, this.fieldNamingStrategy.getClass()));
        }
        this.fieldName = fName;
        return this.fieldName;
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return this.getField() != null && this.getFieldName().toLowerCase(Locale.ROOT).equals("id");
    }

    @Override
    public boolean isExpirationProperty() {
        return (Boolean)this.isExpiration.get();
    }
}

