/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.io.Serializable;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.repository.config.ReactiveRepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.support.ReactiveCouchbaseRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class ReactiveCouchbaseRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private ReactiveRepositoryOperationsMapping couchbaseOperationsMapping;

    public ReactiveCouchbaseRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setCouchbaseOperations(ReactiveCouchbaseOperations reactiveCouchbaseOperations) {
        this.setReactiveCouchbaseOperationsMapping(new ReactiveRepositoryOperationsMapping(reactiveCouchbaseOperations));
    }

    public void setReactiveCouchbaseOperationsMapping(ReactiveRepositoryOperationsMapping couchbaseOperationsMapping) {
        this.couchbaseOperationsMapping = couchbaseOperationsMapping;
        this.setMappingContext(couchbaseOperationsMapping.getMappingContext());
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.couchbaseOperationsMapping);
    }

    protected ReactiveCouchbaseRepositoryFactory getFactoryInstance(ReactiveRepositoryOperationsMapping couchbaseOperationsMapping) {
        return new ReactiveCouchbaseRepositoryFactory(couchbaseOperationsMapping);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.couchbaseOperationsMapping, (String)"operationsMapping must not be null!");
    }
}

