/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.AbstractReactiveCouchbaseQuery;
import org.springframework.data.couchbase.repository.query.N1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class ReactivePartTreeCouchbaseQuery
extends AbstractReactiveCouchbaseQuery {
    private final PartTree tree;
    private final CouchbaseConverter converter;
    private static final Logger LOG = LoggerFactory.getLogger(ReactivePartTreeCouchbaseQuery.class);

    public ReactivePartTreeCouchbaseQuery(ReactiveCouchbaseQueryMethod method, ReactiveCouchbaseOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, operations, expressionParser, evaluationContextProvider);
        this.tree = new PartTree(method.getName(), method.getResultProcessor().getReturnedType().getDomainType());
        this.converter = operations.getConverter();
    }

    public PartTree getTree() {
        return this.tree;
    }

    @Override
    protected Query createQuery(ParametersParameterAccessor accessor) {
        N1qlQueryCreator creator = new N1qlQueryCreator(this.tree, (ParameterAccessor)accessor, this.getQueryMethod(), this.converter, ((ReactiveCouchbaseOperations)this.getOperations()).getBucketName());
        Query query = (Query)creator.createQuery();
        if (this.tree.isLimiting()) {
            query.limit(this.tree.getMaxResults());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query {} for * fields.", (Object)query.export(new int[0][]));
        }
        return query;
    }

    @Override
    protected Query createCountQuery(ParametersParameterAccessor accessor) {
        Query query = (Query)new N1qlQueryCreator(this.tree, (ParameterAccessor)accessor, this.getQueryMethod(), this.converter, ((ReactiveCouchbaseOperations)this.getOperations()).getBucketName()).createQuery();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created query {} for * fields.", (Object)query.export(new int[0][]));
        }
        return query;
    }

    @Override
    protected boolean isLimiting() {
        return this.tree.isLimiting();
    }
}

