/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.Collection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplateSupport;
import org.springframework.data.couchbase.core.ReactiveExistsByIdOperation;
import org.springframework.data.couchbase.core.ReactiveExistsByIdOperationSupport;
import org.springframework.data.couchbase.core.ReactiveFindByAnalyticsOperation;
import org.springframework.data.couchbase.core.ReactiveFindByAnalyticsOperationSupport;
import org.springframework.data.couchbase.core.ReactiveFindByIdOperation;
import org.springframework.data.couchbase.core.ReactiveFindByIdOperationSupport;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveFindByQueryOperationSupport;
import org.springframework.data.couchbase.core.ReactiveFindFromReplicasByIdOperation;
import org.springframework.data.couchbase.core.ReactiveFindFromReplicasByIdOperationSupport;
import org.springframework.data.couchbase.core.ReactiveInsertByIdOperation;
import org.springframework.data.couchbase.core.ReactiveInsertByIdOperationSupport;
import org.springframework.data.couchbase.core.ReactiveRemoveByIdOperation;
import org.springframework.data.couchbase.core.ReactiveRemoveByIdOperationSupport;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperation;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperationSupport;
import org.springframework.data.couchbase.core.ReactiveReplaceByIdOperation;
import org.springframework.data.couchbase.core.ReactiveReplaceByIdOperationSupport;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.ReactiveUpsertByIdOperation;
import org.springframework.data.couchbase.core.ReactiveUpsertByIdOperationSupport;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;

public class ReactiveCouchbaseTemplate
implements ReactiveCouchbaseOperations,
ApplicationContextAware {
    private final CouchbaseClientFactory clientFactory;
    private final CouchbaseConverter converter;
    private final PersistenceExceptionTranslator exceptionTranslator;
    private final ReactiveCouchbaseTemplateSupport templateSupport;

    public ReactiveCouchbaseTemplate(CouchbaseClientFactory clientFactory, CouchbaseConverter converter) {
        this(clientFactory, converter, new JacksonTranslationService());
    }

    public ReactiveCouchbaseTemplate(CouchbaseClientFactory clientFactory, CouchbaseConverter converter, TranslationService translationService) {
        this.clientFactory = clientFactory;
        this.converter = converter;
        this.exceptionTranslator = clientFactory.getExceptionTranslator();
        this.templateSupport = new ReactiveCouchbaseTemplateSupport(converter, translationService);
    }

    @Override
    public <T> ReactiveFindByIdOperation.ReactiveFindById<T> findById(Class<T> domainType) {
        return new ReactiveFindByIdOperationSupport(this).findById(domainType);
    }

    @Override
    public ReactiveExistsByIdOperation.ReactiveExistsById existsById() {
        return new ReactiveExistsByIdOperationSupport(this).existsById();
    }

    @Override
    public <T> ReactiveFindByAnalyticsOperation.ReactiveFindByAnalytics<T> findByAnalytics(Class<T> domainType) {
        return new ReactiveFindByAnalyticsOperationSupport(this).findByAnalytics(domainType);
    }

    @Override
    public <T> ReactiveFindByQueryOperation.ReactiveFindByQuery<T> findByQuery(Class<T> domainType) {
        return new ReactiveFindByQueryOperationSupport(this).findByQuery(domainType);
    }

    @Override
    public <T> ReactiveFindFromReplicasByIdOperation.ReactiveFindFromReplicasById<T> findFromReplicasById(Class<T> domainType) {
        return new ReactiveFindFromReplicasByIdOperationSupport(this).findFromReplicasById(domainType);
    }

    @Override
    public <T> ReactiveInsertByIdOperation.ReactiveInsertById<T> insertById(Class<T> domainType) {
        return new ReactiveInsertByIdOperationSupport(this).insertById(domainType);
    }

    @Override
    public ReactiveRemoveByIdOperation.ReactiveRemoveById removeById() {
        return new ReactiveRemoveByIdOperationSupport(this).removeById();
    }

    @Override
    public <T> ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ReactiveRemoveByQueryOperationSupport(this).removeByQuery(domainType);
    }

    @Override
    public <T> ReactiveReplaceByIdOperation.ReactiveReplaceById<T> replaceById(Class<T> domainType) {
        return new ReactiveReplaceByIdOperationSupport(this).replaceById(domainType);
    }

    @Override
    public <T> ReactiveUpsertByIdOperation.ReactiveUpsertById<T> upsertById(Class<T> domainType) {
        return new ReactiveUpsertByIdOperationSupport(this).upsertById(domainType);
    }

    @Override
    public String getBucketName() {
        return this.clientFactory.getBucket().name();
    }

    @Override
    public String getScopeName() {
        return this.clientFactory.getScope().name();
    }

    @Override
    public CouchbaseClientFactory getCouchbaseClientFactory() {
        return this.clientFactory;
    }

    public Collection getCollection(String collectionName) {
        return this.clientFactory.getCollection(collectionName);
    }

    @Override
    public CouchbaseConverter getConverter() {
        return this.converter;
    }

    ReactiveTemplateSupport support() {
        return this.templateSupport;
    }

    RuntimeException potentiallyConvertRuntimeException(RuntimeException ex) {
        DataAccessException resolved = this.exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.templateSupport.setApplicationContext(applicationContext);
    }
}

