/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.analytics.AnalyticsScanConsistency;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableFindByAnalyticsOperation;
import org.springframework.data.couchbase.core.NonReactiveSupportWrapper;
import org.springframework.data.couchbase.core.ReactiveFindByAnalyticsOperationSupport;
import org.springframework.data.couchbase.core.query.AnalyticsQuery;

public class ExecutableFindByAnalyticsOperationSupport
implements ExecutableFindByAnalyticsOperation {
    private static final AnalyticsQuery ALL_QUERY = new AnalyticsQuery();
    private final CouchbaseTemplate template;

    public ExecutableFindByAnalyticsOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableFindByAnalyticsOperation.ExecutableFindByAnalytics<T> findByAnalytics(Class<T> domainType) {
        return new ExecutableFindByAnalyticsSupport<T>(this.template, domainType, ALL_QUERY, AnalyticsScanConsistency.NOT_BOUNDED);
    }

    static class ExecutableFindByAnalyticsSupport<T>
    implements ExecutableFindByAnalyticsOperation.ExecutableFindByAnalytics<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final ReactiveFindByAnalyticsOperationSupport.ReactiveFindByAnalyticsSupport<T> reactiveSupport;
        private final AnalyticsQuery query;
        private final AnalyticsScanConsistency scanConsistency;

        ExecutableFindByAnalyticsSupport(CouchbaseTemplate template, Class<T> domainType, AnalyticsQuery query, AnalyticsScanConsistency scanConsistency) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.reactiveSupport = new ReactiveFindByAnalyticsOperationSupport.ReactiveFindByAnalyticsSupport<T>(template.reactive(), domainType, query, scanConsistency, new NonReactiveSupportWrapper(template.support()));
            this.scanConsistency = scanConsistency;
        }

        @Override
        public T oneValue() {
            return (T)this.reactiveSupport.one().block();
        }

        @Override
        public T firstValue() {
            return (T)this.reactiveSupport.first().block();
        }

        @Override
        public List<T> all() {
            return (List)this.reactiveSupport.all().collectList().block();
        }

        @Override
        public ExecutableFindByAnalyticsOperation.TerminatingFindByAnalytics<T> matching(AnalyticsQuery query) {
            return new ExecutableFindByAnalyticsSupport<T>(this.template, this.domainType, query, this.scanConsistency);
        }

        @Override
        @Deprecated
        public ExecutableFindByAnalyticsOperation.FindByAnalyticsWithQuery<T> consistentWith(AnalyticsScanConsistency scanConsistency) {
            return new ExecutableFindByAnalyticsSupport<T>(this.template, this.domainType, this.query, scanConsistency);
        }

        @Override
        public ExecutableFindByAnalyticsOperation.FindByAnalyticsWithConsistency<T> withConsistency(AnalyticsScanConsistency scanConsistency) {
            return new ExecutableFindByAnalyticsSupport<T>(this.template, this.domainType, this.query, scanConsistency);
        }

        @Override
        public Stream<T> stream() {
            return this.reactiveSupport.all().toStream();
        }

        @Override
        public long count() {
            return (Long)this.reactiveSupport.count().block();
        }

        @Override
        public boolean exists() {
            return this.count() > 0L;
        }
    }
}

