/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.Collection;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.CouchbaseTemplateSupport;
import org.springframework.data.couchbase.core.ExecutableExistsByIdOperation;
import org.springframework.data.couchbase.core.ExecutableExistsByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableFindByAnalyticsOperation;
import org.springframework.data.couchbase.core.ExecutableFindByAnalyticsOperationSupport;
import org.springframework.data.couchbase.core.ExecutableFindByIdOperation;
import org.springframework.data.couchbase.core.ExecutableFindByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperationSupport;
import org.springframework.data.couchbase.core.ExecutableFindFromReplicasByIdOperation;
import org.springframework.data.couchbase.core.ExecutableFindFromReplicasByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableInsertByIdOperation;
import org.springframework.data.couchbase.core.ExecutableInsertByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableRemoveByIdOperation;
import org.springframework.data.couchbase.core.ExecutableRemoveByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableRemoveByQueryOperation;
import org.springframework.data.couchbase.core.ExecutableRemoveByQueryOperationSupport;
import org.springframework.data.couchbase.core.ExecutableReplaceByIdOperation;
import org.springframework.data.couchbase.core.ExecutableReplaceByIdOperationSupport;
import org.springframework.data.couchbase.core.ExecutableUpsertByIdOperation;
import org.springframework.data.couchbase.core.ExecutableUpsertByIdOperationSupport;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.TemplateSupport;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.translation.JacksonTranslationService;
import org.springframework.data.couchbase.core.convert.translation.TranslationService;
import org.springframework.data.couchbase.core.index.CouchbasePersistentEntityIndexCreator;
import org.springframework.data.couchbase.core.mapping.CouchbaseMappingContext;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;

public class CouchbaseTemplate
implements CouchbaseOperations,
ApplicationContextAware {
    private final CouchbaseClientFactory clientFactory;
    private final CouchbaseConverter converter;
    private final CouchbaseTemplateSupport templateSupport;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final ReactiveCouchbaseTemplate reactiveCouchbaseTemplate;
    @Nullable
    private CouchbasePersistentEntityIndexCreator indexCreator;

    public CouchbaseTemplate(CouchbaseClientFactory clientFactory, CouchbaseConverter converter) {
        this(clientFactory, converter, new JacksonTranslationService());
    }

    public CouchbaseTemplate(CouchbaseClientFactory clientFactory, CouchbaseConverter converter, TranslationService translationService) {
        CouchbaseMappingContext cmc;
        this.clientFactory = clientFactory;
        this.converter = converter;
        this.templateSupport = new CouchbaseTemplateSupport(converter, translationService);
        this.reactiveCouchbaseTemplate = new ReactiveCouchbaseTemplate(clientFactory, converter, translationService);
        this.mappingContext = this.converter.getMappingContext();
        if (this.mappingContext instanceof CouchbaseMappingContext && (cmc = (CouchbaseMappingContext)this.mappingContext).isAutoIndexCreation()) {
            this.indexCreator = new CouchbasePersistentEntityIndexCreator(cmc, this);
        }
    }

    @Override
    public <T> ExecutableUpsertByIdOperation.ExecutableUpsertById<T> upsertById(Class<T> domainType) {
        return new ExecutableUpsertByIdOperationSupport(this).upsertById(domainType);
    }

    @Override
    public <T> ExecutableInsertByIdOperation.ExecutableInsertById<T> insertById(Class<T> domainType) {
        return new ExecutableInsertByIdOperationSupport(this).insertById(domainType);
    }

    @Override
    public <T> ExecutableReplaceByIdOperation.ExecutableReplaceById<T> replaceById(Class<T> domainType) {
        return new ExecutableReplaceByIdOperationSupport(this).replaceById(domainType);
    }

    @Override
    public <T> ExecutableFindByIdOperation.ExecutableFindById<T> findById(Class<T> domainType) {
        return new ExecutableFindByIdOperationSupport(this).findById(domainType);
    }

    @Override
    public <T> ExecutableFindFromReplicasByIdOperation.ExecutableFindFromReplicasById<T> findFromReplicasById(Class<T> domainType) {
        return new ExecutableFindFromReplicasByIdOperationSupport(this).findFromReplicasById(domainType);
    }

    @Override
    public <T> ExecutableFindByQueryOperation.ExecutableFindByQuery<T> findByQuery(Class<T> domainType) {
        return new ExecutableFindByQueryOperationSupport(this).findByQuery(domainType);
    }

    @Override
    public <T> ExecutableFindByAnalyticsOperation.ExecutableFindByAnalytics<T> findByAnalytics(Class<T> domainType) {
        return new ExecutableFindByAnalyticsOperationSupport(this).findByAnalytics(domainType);
    }

    @Override
    public ExecutableRemoveByIdOperation.ExecutableRemoveById removeById() {
        return new ExecutableRemoveByIdOperationSupport(this).removeById();
    }

    @Override
    public ExecutableExistsByIdOperation.ExecutableExistsById existsById() {
        return new ExecutableExistsByIdOperationSupport(this).existsById();
    }

    @Override
    public <T> ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ExecutableRemoveByQueryOperationSupport(this).removeByQuery(domainType);
    }

    @Override
    public String getBucketName() {
        return this.clientFactory.getBucket().name();
    }

    @Override
    public String getScopeName() {
        return this.clientFactory.getScope().name();
    }

    @Override
    public CouchbaseClientFactory getCouchbaseClientFactory() {
        return this.clientFactory;
    }

    public Collection getCollection(String collectionName) {
        return this.clientFactory.getCollection(collectionName);
    }

    @Override
    public CouchbaseConverter getConverter() {
        return this.converter;
    }

    public ReactiveCouchbaseTemplate reactive() {
        return this.reactiveCouchbaseTemplate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.prepareIndexCreator(applicationContext);
        this.templateSupport.setApplicationContext(applicationContext);
        this.reactiveCouchbaseTemplate.setApplicationContext(applicationContext);
    }

    private void prepareIndexCreator(ApplicationContext context) {
        String[] indexCreators;
        for (String creator : indexCreators = context.getBeanNamesForType(CouchbasePersistentEntityIndexCreator.class)) {
            CouchbasePersistentEntityIndexCreator creatorBean = (CouchbasePersistentEntityIndexCreator)context.getBean(creator, CouchbasePersistentEntityIndexCreator.class);
            if (!creatorBean.isIndexCreatorFor(this.mappingContext)) continue;
            return;
        }
        if (context instanceof ConfigurableApplicationContext && this.indexCreator != null) {
            ((ConfigurableApplicationContext)context).addApplicationListener((ApplicationListener)this.indexCreator);
            if (this.mappingContext instanceof CouchbaseMappingContext) {
                CouchbaseMappingContext cmc = (CouchbaseMappingContext)this.mappingContext;
                cmc.setIndexCreator(this.indexCreator);
            }
        }
    }

    TemplateSupport support() {
        return this.templateSupport;
    }
}

