/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.view.AsyncViewRow;
import com.couchbase.client.java.view.ViewQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.CouchbaseQueryExecutionException;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ReactiveCouchbaseParameterAccessor;
import org.springframework.data.couchbase.repository.query.ViewQueryCreator;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import rx.Observable;

public class ReactiveViewBasedCouchbaseQuery
implements RepositoryQuery {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveViewBasedCouchbaseQuery.class);
    private final CouchbaseQueryMethod method;
    private final RxJavaCouchbaseOperations operations;

    public ReactiveViewBasedCouchbaseQuery(CouchbaseQueryMethod method, RxJavaCouchbaseOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    public Object execute(Object[] runtimeParams) {
        if (this.method.hasViewName()) {
            return this.deriveAndExecute(runtimeParams);
        }
        return this.guessViewAndExecute();
    }

    protected Object guessViewAndExecute() {
        String designDoc = ReactiveViewBasedCouchbaseQuery.designDocName(this.method);
        String methodName = this.method.getName();
        boolean isExplicitReduce = this.method.hasViewAnnotation() && this.method.getViewAnnotation().reduce();
        boolean isReduce = methodName.startsWith("count") || isExplicitReduce;
        String viewName = StringUtils.uncapitalize((String)methodName.replaceFirst("find|count", ""));
        ViewQuery simpleQuery = ViewQuery.from((String)designDoc, (String)viewName).stale(this.operations.getDefaultConsistency().viewConsistency());
        if (isReduce) {
            simpleQuery.reduce();
            return this.executeReduce(simpleQuery, designDoc, viewName);
        }
        return this.execute(simpleQuery);
    }

    protected Object deriveAndExecute(Object[] runtimeParams) {
        String designDoc = ReactiveViewBasedCouchbaseQuery.designDocName(this.method);
        String viewName = this.method.getViewAnnotation().viewName();
        ViewQuery baseQuery = ViewQuery.from((String)designDoc, (String)viewName).stale(this.operations.getDefaultConsistency().viewConsistency());
        try {
            PartTree tree = new PartTree(this.method.getName(), this.method.getEntityInformation().getJavaType());
            ViewQueryCreator creator = new ViewQueryCreator(tree, (ParameterAccessor)new ReactiveCouchbaseParameterAccessor(this.method, runtimeParams), this.method.getViewAnnotation(), baseQuery, this.operations.getConverter());
            ViewQueryCreator.DerivedViewQuery result = (ViewQueryCreator.DerivedViewQuery)creator.createQuery();
            if (result.isReduce) {
                return this.executeReduce(result.builtQuery, designDoc, viewName);
            }
            return this.execute(result.builtQuery);
        }
        catch (PropertyReferenceException e) {
            if (e.getPropertyName().equals(this.method.getName())) {
                return this.execute(baseQuery);
            }
            throw e;
        }
    }

    protected Object execute(ViewQuery query) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing view query: " + query.toString());
        }
        return ReactiveWrapperConverters.toWrapper(this.operations.findByView(query, this.method.getEntityInformation().getJavaType()), Flux.class);
    }

    protected Object executeReduce(ViewQuery query, String designDoc, String viewName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing view reduced query: " + query.toString());
        }
        return ReactiveWrapperConverters.toWrapper((Object)this.operations.queryView(query).flatMap(asyncViewResult -> asyncViewResult.error().flatMap(error -> Observable.error((Throwable)((Object)new CouchbaseQueryExecutionException("Unable to execute reducing view " + viewName + " in design document " + designDoc + "due to error:" + error.toString())))).switchIfEmpty(asyncViewResult.rows())).map(row -> {
            AsyncViewRow asyncViewRow = (AsyncViewRow)row;
            return asyncViewRow.value();
        }).take(1), Flux.class);
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    private static String designDocName(CouchbaseQueryMethod method) {
        if (method.hasViewSpecification()) {
            return method.getViewAnnotation().designDocument();
        }
        if (method.hasViewAnnotation()) {
            return StringUtils.uncapitalize((String)method.getEntityInformation().getJavaType().getSimpleName());
        }
        throw new IllegalStateException("View-based query should only happen on a method with @View annotation");
    }
}

