/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.query.Consistency;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CouchbaseTemplateParser
extends AbstractSingleBeanDefinitionParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseTemplateParser.class);

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "couchbaseTemplate";
    }

    protected Class getBeanClass(Element element) {
        return CouchbaseTemplate.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder bean) {
        String consistencyValue;
        String clusterInfoRef = element.getAttribute("clusterInfo-ref");
        String bucketRef = element.getAttribute("bucket-ref");
        String converterRef = element.getAttribute("converter-ref");
        String translationServiceRef = element.getAttribute("translation-service-ref");
        bean.addConstructorArgReference(StringUtils.hasText((String)clusterInfoRef) ? clusterInfoRef : "couchbaseClusterInfo");
        bean.addConstructorArgReference(StringUtils.hasText((String)bucketRef) ? bucketRef : "couchbaseBucket");
        if (StringUtils.hasText((String)converterRef)) {
            bean.addConstructorArgReference(converterRef);
        }
        if (StringUtils.hasText((String)translationServiceRef)) {
            bean.addConstructorArgReference(translationServiceRef);
        }
        if ((consistencyValue = element.getAttribute("consistency")) != null) {
            try {
                Consistency consistency = Consistency.valueOf(consistencyValue);
                bean.addPropertyValue("defaultConsistency", (Object)consistency);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Parsed bad consistency value " + consistencyValue + " in xml template configuration, using default");
            }
        }
    }
}

