/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.couchbase.config.CouchbaseClusterInfoFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CouchbaseClusterInfoParser
extends AbstractSingleBeanDefinitionParser {
    public static final String CLUSTER_REF_ATTR = "cluster-ref";
    public static final String LOGIN_ATTR = "login";
    public static final String PASSWORD_ATTR = "password";

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "couchbaseClusterInfo";
    }

    protected Class getBeanClass(Element element) {
        return CouchbaseClusterInfoFactoryBean.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String clusterRef = element.getAttribute(CLUSTER_REF_ATTR);
        if (!StringUtils.hasText((String)clusterRef)) {
            clusterRef = "couchbaseCluster";
        }
        builder.addConstructorArgReference(clusterRef);
        String login = element.getAttribute(LOGIN_ATTR);
        if (!StringUtils.hasText((String)login)) {
            login = "default";
        }
        builder.addConstructorArgValue((Object)login);
        String password = element.getAttribute(PASSWORD_ATTR);
        if (!StringUtils.hasText((String)password)) {
            password = "";
        }
        builder.addConstructorArgValue((Object)password);
    }
}

