/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import java.util.Iterator;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.support.N1qlQueryCreatorUtils;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class N1qlQueryCreator
extends AbstractQueryCreator<LimitPath, Expression> {
    private final WherePath selectFrom;
    private final CouchbaseConverter converter;
    private final CouchbaseQueryMethod queryMethod;
    private final ParameterAccessor accessor;

    public N1qlQueryCreator(PartTree tree, ParameterAccessor parameters, WherePath selectFrom, CouchbaseConverter converter, CouchbaseQueryMethod queryMethod) {
        super(tree, parameters);
        this.selectFrom = selectFrom;
        this.converter = converter;
        this.queryMethod = queryMethod;
        this.accessor = parameters;
    }

    protected Expression create(Part part, Iterator<Object> iterator) {
        return N1qlQueryCreatorUtils.prepareExpression(this.converter, part, iterator);
    }

    protected Expression and(Part part, Expression base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, iterator);
        }
        return base.and(this.create(part, iterator));
    }

    protected Expression or(Expression base, Expression criteria) {
        return base.or(criteria);
    }

    protected LimitPath complete(Expression criteria, Sort sort) {
        Expression whereCriteria = N1qlUtils.createWhereFilterForEntity(criteria, this.converter, this.queryMethod.getEntityInformation());
        GroupByPath selectFromWhere = this.selectFrom.where(whereCriteria);
        if ((this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) && this.accessor.getPageable().isPaged()) {
            Pageable pageable = this.accessor.getPageable();
            sort = pageable.getSort();
        }
        if (sort.isSorted()) {
            com.couchbase.client.java.query.dsl.Sort[] cbSorts = N1qlUtils.createSort(sort, this.converter);
            return selectFromWhere.orderBy(cbSorts);
        }
        return selectFromWhere;
    }
}

