/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryInformationSupport;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;

public class AotRepositoryInformation
extends RepositoryInformationSupport
implements RepositoryInformation {
    private final RepositoryComposition fragmentsComposition;
    private final RepositoryComposition baseComposition;
    private final RepositoryComposition composition;

    public AotRepositoryInformation(RepositoryMetadata repositoryMetadata, Class<?> repositoryBaseClass, Collection<RepositoryFragment<?>> fragments) {
        super(() -> repositoryMetadata, () -> repositoryBaseClass);
        this.fragmentsComposition = RepositoryComposition.fromMetadata(this.getMetadata()).append(RepositoryComposition.RepositoryFragments.from(fragments));
        this.baseComposition = RepositoryComposition.of(RepositoryFragment.structural(this.getRepositoryBaseClass())).withArgumentConverter(this.fragmentsComposition.getArgumentConverter()).withMethodLookup(this.fragmentsComposition.getMethodLookup());
        this.composition = this.fragmentsComposition.append(this.baseComposition.getFragments());
    }

    @Override
    public Set<RepositoryFragment<?>> getFragments() {
        return this.fragmentsComposition.getFragments().toSet();
    }

    @Override
    public boolean isCustomMethod(Method method) {
        return this.fragmentsComposition.findMethod(method).isPresent();
    }

    @Override
    public boolean isBaseClassMethod(Method method) {
        return this.baseComposition.findMethod(method).isPresent();
    }

    @Override
    public Method getTargetClassMethod(Method method) {
        return this.baseComposition.findMethod(method).orElse(method);
    }

    @Override
    public RepositoryComposition getRepositoryComposition() {
        return this.composition;
    }
}

