/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.reactive.AwaitKt;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.QueryExecutionResultHandler;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;

class QueryExecutorMethodInterceptor
implements MethodInterceptor {
    private final Map<Method, RepositoryQuery> queries;
    private final Map<Method, QueryMethodInvoker> invocationMetadataCache = new ConcurrentReferenceHashMap();
    private final QueryExecutionResultHandler resultHandler;
    private final NamedQueries namedQueries;
    private final List<QueryCreationListener<?>> queryPostProcessors;

    public QueryExecutorMethodInterceptor(RepositoryInformation repositoryInformation, ProjectionFactory projectionFactory, Optional<QueryLookupStrategy> queryLookupStrategy, NamedQueries namedQueries, List<QueryCreationListener<?>> queryPostProcessors) {
        this.namedQueries = namedQueries;
        this.queryPostProcessors = queryPostProcessors;
        this.resultHandler = new QueryExecutionResultHandler(RepositoryFactorySupport.CONVERSION_SERVICE);
        if (!queryLookupStrategy.isPresent() && repositoryInformation.hasQueryMethods()) {
            throw new IllegalStateException("You have defined query methods in the repository but do not have any query lookup strategy defined. The infrastructure apparently does not support query methods!");
        }
        this.queries = queryLookupStrategy.map(it -> this.mapMethodsToQuery(repositoryInformation, (QueryLookupStrategy)it, projectionFactory)).orElse(Collections.emptyMap());
    }

    private Map<Method, RepositoryQuery> mapMethodsToQuery(RepositoryInformation repositoryInformation, QueryLookupStrategy lookupStrategy, ProjectionFactory projectionFactory) {
        return repositoryInformation.getQueryMethods().stream().map(method -> this.lookupQuery((Method)method, repositoryInformation, lookupStrategy, projectionFactory)).peek(pair -> this.invokeListeners((RepositoryQuery)pair.getSecond())).collect(Pair.toMap());
    }

    private Pair<Method, RepositoryQuery> lookupQuery(Method method, RepositoryInformation information, QueryLookupStrategy strategy, ProjectionFactory projectionFactory) {
        return Pair.of(method, strategy.resolveQuery(method, information, projectionFactory, this.namedQueries));
    }

    private void invokeListeners(RepositoryQuery query) {
        for (QueryCreationListener<?> listener : this.queryPostProcessors) {
            ResolvableType typeArgument = ResolvableType.forClass(QueryCreationListener.class, listener.getClass()).getGeneric(new int[]{0});
            if (typeArgument == null || !typeArgument.isAssignableFrom(ResolvableType.forClass(query.getClass()))) continue;
            listener.onCreation(query);
        }
    }

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        QueryExecutionConverters.ExecutionAdapter executionAdapter = QueryExecutionConverters.getExecutionAdapter(method.getReturnType());
        if (executionAdapter == null) {
            return this.resultHandler.postProcessInvocationResult(this.doInvoke(invocation), method);
        }
        return executionAdapter.apply(() -> this.resultHandler.postProcessInvocationResult(this.doInvoke(invocation), method));
    }

    @Nullable
    private Object doInvoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (this.hasQueryFor(method)) {
            QueryMethodInvoker invocationMetadata = this.invocationMetadataCache.get(method);
            if (invocationMetadata == null) {
                invocationMetadata = new QueryMethodInvoker(method);
                this.invocationMetadataCache.put(method, invocationMetadata);
            }
            RepositoryQuery repositoryQuery = this.queries.get(method);
            return invocationMetadata.invoke(repositoryQuery, invocation.getArguments());
        }
        return invocation.proceed();
    }

    private boolean hasQueryFor(Method method) {
        return this.queries.containsKey(method);
    }

    static class QueryMethodInvoker {
        private final boolean suspendedDeclaredMethod;
        private final Class<?> returnedType;
        private final boolean returnsReactiveType;

        QueryMethodInvoker(Method invokedMethod) {
            if (KotlinDetector.isKotlinReflectPresent()) {
                this.suspendedDeclaredMethod = KotlinReflectionUtils.isSuspend(invokedMethod);
                this.returnedType = this.suspendedDeclaredMethod ? KotlinReflectionUtils.getReturnType(invokedMethod) : invokedMethod.getReturnType();
            } else {
                this.suspendedDeclaredMethod = false;
                this.returnedType = invokedMethod.getReturnType();
            }
            this.returnsReactiveType = ReactiveWrappers.supports(this.returnedType);
        }

        @Nullable
        public Object invoke(RepositoryQuery query, Object[] args) {
            return this.suspendedDeclaredMethod ? this.invokeReactiveToSuspend(query, args) : query.execute(args);
        }

        @Nullable
        private Object invokeReactiveToSuspend(RepositoryQuery query, Object[] args) {
            Continuation continuation = (Continuation)args[args.length - 1];
            args[args.length - 1] = null;
            Object result = query.execute(args);
            if (this.returnsReactiveType) {
                return ReactiveWrapperConverters.toWrapper(result, this.returnedType);
            }
            Publisher publisher = result instanceof Publisher ? (Publisher)result : ReactiveWrapperConverters.toWrapper(result, Publisher.class);
            return AwaitKt.awaitFirstOrNull((Publisher)publisher, (Continuation)continuation);
        }
    }
}

