/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.util.Assert;

public class SimpleTypeHolder {
    private static final Set<Class<?>> DEFAULTS = new HashSet<Class<?>>(){
        private static final long serialVersionUID = -1738594126505221500L;
        {
            this.add(Boolean.TYPE);
            this.add(boolean[].class);
            this.add(Long.TYPE);
            this.add(long[].class);
            this.add(Short.TYPE);
            this.add(short[].class);
            this.add(Integer.TYPE);
            this.add(int[].class);
            this.add(Byte.TYPE);
            this.add(byte[].class);
            this.add(Float.TYPE);
            this.add(float[].class);
            this.add(Double.TYPE);
            this.add(double[].class);
            this.add(Character.TYPE);
            this.add(char[].class);
            this.add(Boolean.class);
            this.add(Long.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Byte.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(Character.class);
            this.add(String.class);
            this.add(Date.class);
            this.add(Locale.class);
            this.add(Class.class);
            this.add(Enum.class);
        }
    };
    public static final SimpleTypeHolder DEFAULT = new SimpleTypeHolder();
    private volatile Map<Class<?>, Boolean> simpleTypes;

    protected SimpleTypeHolder() {
        this(Collections.emptySet(), true);
    }

    public SimpleTypeHolder(Set<? extends Class<?>> customSimpleTypes, boolean registerDefaults) {
        Assert.notNull(customSimpleTypes, (String)"CustomSimpleTypes must not be null!");
        this.simpleTypes = new WeakHashMap(customSimpleTypes.size() + DEFAULTS.size());
        this.register(customSimpleTypes);
        if (registerDefaults) {
            this.register(DEFAULTS);
        }
    }

    public SimpleTypeHolder(Set<? extends Class<?>> customSimpleTypes, SimpleTypeHolder source) {
        Assert.notNull(customSimpleTypes, (String)"CustomSimpleTypes must not be null!");
        Assert.notNull((Object)source, (String)"SourceTypeHolder must not be null!");
        this.simpleTypes = new WeakHashMap(customSimpleTypes.size() + source.simpleTypes.size());
        this.register(customSimpleTypes);
        this.registerCachePositives(source.simpleTypes);
    }

    private void registerCachePositives(Map<Class<?>, Boolean> source) {
        for (Map.Entry<Class<?>, Boolean> entry : source.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            this.simpleTypes.put(entry.getKey(), true);
        }
    }

    public boolean isSimpleType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        Map<Class<?>, Boolean> localSimpleTypes = this.simpleTypes;
        Boolean isSimpleType = localSimpleTypes.get(type);
        if (Object.class.equals(type) || Enum.class.isAssignableFrom(type)) {
            return true;
        }
        if (isSimpleType != null) {
            return isSimpleType;
        }
        String typeName = type.getName();
        if (typeName.startsWith("java.lang") || type.getName().startsWith("java.time") || typeName.equals("kotlin.Unit")) {
            return true;
        }
        for (Class<?> simpleType : localSimpleTypes.keySet()) {
            if (!simpleType.isAssignableFrom(type)) continue;
            isSimpleType = localSimpleTypes.get(simpleType);
            this.simpleTypes = SimpleTypeHolder.put(localSimpleTypes, type, isSimpleType);
            return isSimpleType;
        }
        this.simpleTypes = SimpleTypeHolder.put(localSimpleTypes, type, false);
        return false;
    }

    private void register(Collection<? extends Class<?>> types) {
        types.forEach(customSimpleType -> this.simpleTypes.put((Class<?>)customSimpleType, true));
    }

    private static Map<Class<?>, Boolean> put(Map<Class<?>, Boolean> simpleTypes, Class<?> type, boolean isSimpleType) {
        WeakHashMap copy = new WeakHashMap(simpleTypes);
        copy.put(type, isSimpleType);
        return copy;
    }
}

