/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.repository.query.spi.Function;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class Functions {
    private static final String MESSAGE_TEMPLATE = "There are multiple matching methods of name '%s' for parameter types (%s), but no exact match. Make sure to provide only one matching overload or one with exactly those types.";
    private final MultiValueMap<NameAndArgumentCount, Function> functions = new LinkedMultiValueMap();

    Functions() {
    }

    void addAll(Map<String, Function> newFunctions) {
        newFunctions.forEach((n, f) -> {
            NameAndArgumentCount k = NameAndArgumentCount.of(n, f.getParameterCount());
            List<Function> currentElements = this.get(k);
            if (!Functions.contains(currentElements, f)) {
                this.functions.add((Object)k, f);
            }
        });
    }

    void addAll(MultiValueMap<NameAndArgumentCount, Function> newFunctions) {
        newFunctions.forEach((k, list) -> {
            List<Function> currentElements = this.get((NameAndArgumentCount)k);
            list.stream().filter(f -> !Functions.contains(currentElements, f)).forEach(f -> this.functions.add(k, f));
        });
    }

    List<Function> get(NameAndArgumentCount key) {
        return (List)this.functions.getOrDefault((Object)key, Collections.emptyList());
    }

    Optional<Function> get(String name, List<TypeDescriptor> argumentTypes) {
        Stream<Function> candidates = this.get(NameAndArgumentCount.of(name, argumentTypes.size())).stream().filter(f -> f.supports(argumentTypes));
        return Functions.bestMatch(candidates.collect(Collectors.toList()), argumentTypes);
    }

    private static boolean contains(List<Function> elements, Function f) {
        return elements.stream().anyMatch(f::isSignatureEqual);
    }

    private static Optional<Function> bestMatch(List<Function> candidates, List<TypeDescriptor> argumentTypes) {
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        if (candidates.size() == 1) {
            return Optional.of(candidates.get(0));
        }
        Optional<Function> exactMatch = candidates.stream().filter(f -> f.supportsExact(argumentTypes)).findFirst();
        if (!exactMatch.isPresent()) {
            throw new IllegalStateException(Functions.createErrorMessage(candidates, argumentTypes));
        }
        return exactMatch;
    }

    private static String createErrorMessage(List<Function> candidates, List<TypeDescriptor> argumentTypes) {
        String argumentTypeString = argumentTypes.stream().map(TypeDescriptor::getName).collect(Collectors.joining(","));
        return String.format(MESSAGE_TEMPLATE, candidates.get(0).getName(), argumentTypeString);
    }

    static final class NameAndArgumentCount {
        private final String name;
        private final int count;

        static NameAndArgumentCount of(Method m) {
            return NameAndArgumentCount.of(m.getName(), m.getParameterCount());
        }

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameAndArgumentCount)) {
                return false;
            }
            NameAndArgumentCount other = (NameAndArgumentCount)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getCount() == other.getCount();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + this.getCount();
            return result;
        }

        public String toString() {
            return "Functions.NameAndArgumentCount(name=" + this.getName() + ", count=" + this.getCount() + ")";
        }

        @ConstructorProperties(value={"name", "count"})
        private NameAndArgumentCount(String name, int count) {
            this.name = name;
            this.count = count;
        }

        private static NameAndArgumentCount of(String name, int count) {
            return new NameAndArgumentCount(name, count);
        }
    }
}

