/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.config.ConfigurationUtils;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DefaultRepositoryConfiguration<T extends RepositoryConfigurationSource>
implements RepositoryConfiguration<T> {
    public static final String DEFAULT_REPOSITORY_IMPLEMENTATION_POSTFIX = "Impl";
    private static final QueryLookupStrategy.Key DEFAULT_QUERY_LOOKUP_STRATEGY = QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND;
    @NonNull
    private final T configurationSource;
    @NonNull
    private final BeanDefinition definition;
    @NonNull
    private final RepositoryConfigurationExtension extension;

    public String getBeanId() {
        return StringUtils.uncapitalize((String)ClassUtils.getShortName((String)this.getRepositoryBaseClassName().orElseThrow(() -> new IllegalStateException("Can't create bean identifier without a repository base class defined!"))));
    }

    @Override
    public Object getQueryLookupStrategyKey() {
        return this.configurationSource.getQueryLookupStrategyKey().orElse((Object)DEFAULT_QUERY_LOOKUP_STRATEGY);
    }

    @Override
    public Streamable<String> getBasePackages() {
        return this.configurationSource.getBasePackages();
    }

    @Override
    public String getRepositoryInterface() {
        return ConfigurationUtils.getRequiredBeanClassName(this.definition);
    }

    public RepositoryConfigurationSource getConfigSource() {
        return this.configurationSource;
    }

    @Override
    public Optional<String> getNamedQueriesLocation() {
        return this.configurationSource.getNamedQueryLocation();
    }

    @Override
    public String getImplementationClassName() {
        return ClassUtils.getShortName((String)this.getRepositoryInterface()).concat(this.configurationSource.getRepositoryImplementationPostfix().orElse(DEFAULT_REPOSITORY_IMPLEMENTATION_POSTFIX));
    }

    @Override
    public String getImplementationBeanName() {
        return this.configurationSource.generateBeanName(this.definition) + this.configurationSource.getRepositoryImplementationPostfix().orElse(DEFAULT_REPOSITORY_IMPLEMENTATION_POSTFIX);
    }

    @Override
    @Nullable
    public Object getSource() {
        return this.configurationSource.getSource();
    }

    @Override
    public T getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public Optional<String> getRepositoryBaseClassName() {
        return this.configurationSource.getRepositoryBaseClassName();
    }

    @Override
    public String getRepositoryFactoryBeanClassName() {
        return this.configurationSource.getRepositoryFactoryBeanClassName().orElseGet(() -> this.extension.getRepositoryFactoryBeanClassName());
    }

    @Override
    public boolean isLazyInit() {
        return this.definition.isLazyInit();
    }

    @Override
    public Streamable<TypeFilter> getExcludeFilters() {
        return this.configurationSource.getExcludeFilters();
    }

    @ConstructorProperties(value={"configurationSource", "definition", "extension"})
    public DefaultRepositoryConfiguration(@NonNull T configurationSource, @NonNull BeanDefinition definition, @NonNull RepositoryConfigurationExtension extension) {
        if (configurationSource == null) {
            throw new IllegalArgumentException("configurationSource is null");
        }
        if (definition == null) {
            throw new IllegalArgumentException("definition is null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("extension is null");
        }
        this.configurationSource = configurationSource;
        this.definition = definition;
        this.extension = extension;
    }
}

