/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MappingCassandraEntityInformation<T, ID>
extends PersistentEntityInformation<T, ID>
implements CassandraEntityInformation<T, ID> {
    private final CassandraPersistentEntity<T> entityMetadata;
    private final CassandraConverter converter;

    public MappingCassandraEntityInformation(CassandraPersistentEntity<T> entity, CassandraConverter converter) {
        super(entity);
        this.entityMetadata = entity;
        this.converter = converter;
    }

    @Nullable
    public ID getId(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)this.entityMetadata.getIdProperty();
        return (ID)(idProperty != null ? this.entityMetadata.getIdentifierAccessor(entity).getIdentifier() : this.converter.getId(entity, this.entityMetadata));
    }

    public Class<ID> getIdType() {
        if (this.entityMetadata.getIdProperty() != null) {
            return ((CassandraPersistentProperty)this.entityMetadata.getRequiredIdProperty()).getType();
        }
        return MapId.class;
    }

    @Override
    public String getIdAttribute() {
        return ((CassandraPersistentProperty)this.entityMetadata.getRequiredIdProperty()).getName();
    }

    @Override
    public CqlIdentifier getTableName() {
        return this.entityMetadata.getTableName();
    }
}

