/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.mapping.IdInterfaceException;
import org.springframework.data.mapping.MappingException;
import org.springframework.util.Assert;

public class IdInterfaceExceptions
extends MappingException {
    private final Collection<MappingException> exceptions;
    private final String className;

    public IdInterfaceExceptions(Class<?> idInterfaceClass, Collection<MappingException> exceptions) {
        super(String.format("Mapping Exceptions for %s", idInterfaceClass.getName()));
        Assert.notNull(idInterfaceClass, (String)"CassandraPersistentEntity must not be null");
        this.exceptions = Collections.unmodifiableCollection(new LinkedList<MappingException>(exceptions));
        this.className = idInterfaceClass.getName();
        this.exceptions.forEach(arg_0 -> this.addSuppressed(arg_0));
    }

    public void add(IdInterfaceException e) {
        this.exceptions.add(e);
    }

    public Collection<MappingException> getExceptions() {
        return this.exceptions;
    }

    public Collection<String> getMessages() {
        return this.exceptions.stream().map(Throwable::getMessage).collect(Collectors.toList());
    }

    public int getCount() {
        return this.exceptions.size();
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder(this.className).append(":\n");
        for (MappingException e : this.exceptions) {
            builder.append(e.getMessage()).append("\n");
        }
        return builder.toString();
    }

    public String getIdInterfaceName() {
        return this.className;
    }
}

