/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.data.cassandra.core.DeleteOptions;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.ReactiveCassandraBatchOperations;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.convert.EntityWriter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveCassandraBatchTemplate
implements ReactiveCassandraBatchOperations {
    private final AtomicBoolean executed = new AtomicBoolean();
    private final BatchStatementBuilder batch;
    private final CassandraConverter converter;
    private final CassandraMappingContext mappingContext;
    private final List<Mono<? extends Iterable<? extends BatchableStatement<?>>>> batchMonos = new CopyOnWriteArrayList();
    private final ReactiveCassandraOperations operations;
    private final StatementFactory statementFactory;
    private QueryOptions options = QueryOptions.empty();

    ReactiveCassandraBatchTemplate(ReactiveCassandraTemplate operations, BatchType batchType) {
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        Assert.notNull((Object)batchType, (String)"BatchType must not be null");
        this.operations = operations;
        this.batch = BatchStatement.builder((BatchType)batchType);
        this.converter = operations.getConverter();
        this.mappingContext = this.converter.getMappingContext();
        this.statementFactory = operations.getStatementFactory();
    }

    private void assertNotExecuted() {
        Assert.state((!this.executed.get() ? 1 : 0) != 0, (String)"This Cassandra Batch was already executed");
    }

    protected CassandraConverter getConverter() {
        return this.converter;
    }

    protected CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entityType));
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    @Override
    public Mono<WriteResult> execute() {
        return Mono.defer(() -> {
            if (this.executed.compareAndSet(false, true)) {
                return Flux.merge(this.batchMonos).flatMap(Flux::fromIterable).collectList().flatMap(statements -> {
                    this.batch.addStatements((Iterable)statements);
                    return this.operations.getReactiveCqlOperations().queryForResultSet((Statement<?>)QueryOptionsUtil.addQueryOptions(this.batch.build(), this.options));
                }).flatMap(resultSet -> resultSet.rows().collectList().map(rows -> new WriteResult(resultSet.getAllExecutionInfo(), resultSet.wasApplied(), (List<Row>)rows)));
            }
            return Mono.error((Throwable)new IllegalStateException("This Cassandra Batch was already executed"));
        });
    }

    @Override
    public ReactiveCassandraBatchOperations withTimestamp(long timestamp) {
        this.assertNotExecuted();
        this.batch.setQueryTimestamp(timestamp);
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations withQueryOptions(QueryOptions options) {
        this.assertNotExecuted();
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        this.options = options;
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations addStatement(Mono<? extends BatchableStatement<?>> statement) {
        this.assertNotExecuted();
        Assert.notNull(statement, (String)"Statement mono must not be null");
        this.batchMonos.add(statement.map(List::of));
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations addStatements(Mono<? extends Iterable<? extends BatchableStatement<?>>> statements) {
        this.assertNotExecuted();
        Assert.notNull(statements, (String)"Statements mono must not be null");
        this.batchMonos.add(statements);
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.insert(Arrays.asList(entities));
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Iterable<?> entities) {
        return this.insert(entities, (WriteOptions)InsertOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Mono<? extends Iterable<?>> entities) {
        return this.insert(entities, (WriteOptions)InsertOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.addStatements(this.doInsert(entities, options));
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations insert(Mono<? extends Iterable<?>> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.addStatements(entities.map(entity -> this.doInsert((Iterable<?>)entity, options)));
        return this;
    }

    private Collection<SimpleStatement> doInsert(Iterable<?> entities, WriteOptions options) {
        CassandraMappingContext mappingContext = this.getMappingContext();
        ArrayList<SimpleStatement> insertQueries = new ArrayList<SimpleStatement>();
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            ReactiveCassandraBatchTemplate.assertNotStatement("insert", entity);
            ReactiveCassandraBatchTemplate.assertNotQueryOptions(entity);
            BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)mappingContext.getRequiredPersistentEntity(entity.getClass());
            SimpleStatement insertQuery = this.getStatementFactory().insert(entity, options, persistentEntity, persistentEntity.getTableName()).build();
            insertQueries.add(insertQuery);
        }
        return insertQueries;
    }

    @Override
    public ReactiveCassandraBatchOperations update(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.update(Arrays.asList(entities));
    }

    @Override
    public ReactiveCassandraBatchOperations update(Iterable<?> entities) {
        return this.update(entities, (WriteOptions)UpdateOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations update(Mono<? extends Iterable<?>> entities) {
        return this.update(entities, (WriteOptions)UpdateOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations update(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.addStatements(Mono.just(this.doUpdate(entities, options)));
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations update(Mono<? extends Iterable<?>> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.addStatements(entities.map(entity -> this.doUpdate((Iterable<?>)entity, options)));
        return this;
    }

    private Collection<SimpleStatement> doUpdate(Iterable<?> entities, WriteOptions options) {
        ArrayList<SimpleStatement> updateQueries = new ArrayList<SimpleStatement>();
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            ReactiveCassandraBatchTemplate.assertNotStatement("update", entity);
            ReactiveCassandraBatchTemplate.assertNotQueryOptions(entity);
            CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
            SimpleStatement update = this.getStatementFactory().update(entity, options, persistentEntity, persistentEntity.getTableName()).build();
            updateQueries.add(update);
        }
        return updateQueries;
    }

    @Override
    public ReactiveCassandraBatchOperations delete(Object ... entities) {
        Assert.notNull((Object)entities, (String)"Entities must not be null");
        return this.delete(Arrays.asList(entities));
    }

    @Override
    public ReactiveCassandraBatchOperations delete(Iterable<?> entities) {
        return this.delete(entities, (WriteOptions)DeleteOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations delete(Mono<? extends Iterable<?>> entities) {
        return this.delete(entities, (WriteOptions)DeleteOptions.empty());
    }

    @Override
    public ReactiveCassandraBatchOperations delete(Iterable<?> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.addStatements(Mono.just(this.doDelete(entities, options)));
        return this;
    }

    @Override
    public ReactiveCassandraBatchOperations delete(Mono<? extends Iterable<?>> entities, WriteOptions options) {
        this.assertNotExecuted();
        Assert.notNull(entities, (String)"Entities must not be null");
        Assert.notNull((Object)options, (String)"WriteOptions must not be null");
        this.addStatements(entities.map(it -> this.doDelete((Iterable<?>)it, options)));
        return this;
    }

    private Collection<SimpleStatement> doDelete(Iterable<?> entities, WriteOptions options) {
        ArrayList<SimpleStatement> deleteQueries = new ArrayList<SimpleStatement>();
        for (Object entity : entities) {
            Assert.notNull(entity, (String)"Entity must not be null");
            ReactiveCassandraBatchTemplate.assertNotStatement("delete", entity);
            ReactiveCassandraBatchTemplate.assertNotQueryOptions(entity);
            CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
            SimpleStatement delete = this.getStatementFactory().delete(entity, options, (EntityWriter<Object, Object>)this.getConverter(), persistentEntity.getTableName()).build();
            deleteQueries.add(delete);
        }
        return deleteQueries;
    }

    private static void assertNotQueryOptions(Object o) {
        if (o instanceof QueryOptions) {
            throw new IllegalArgumentException(String.format("%s must not be used as entity; Please make sure to call the appropriate method accepting %s", ClassUtils.getDescriptiveType((Object)o), ClassUtils.getShortName(o.getClass())));
        }
    }

    private static void assertNotStatement(String operation, Object o) {
        if (o instanceof Statement) {
            throw new IllegalArgumentException(String.format("%s cannot use a Statement: %s. Use only entities for %s", StringUtils.capitalize((String)operation), ClassUtils.getDescriptiveType((Object)o), operation));
        }
    }
}

