/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.observability.CassandraObservationConvention;
import org.springframework.data.cassandra.observability.DefaultCassandraObservationConvention;
import org.springframework.data.cassandra.observability.ObservableReactiveSession;
import org.springframework.util.Assert;

public final class ObservableReactiveSessionFactory {
    private ObservableReactiveSessionFactory() {
        throw new UnsupportedOperationException("Can't instantiate a utility class");
    }

    public static ReactiveSession wrap(ReactiveSession session, ObservationRegistry observationRegistry) {
        return ObservableReactiveSessionFactory.wrap(session, "Cassandra", observationRegistry);
    }

    public static ReactiveSession wrap(ReactiveSession session, String remoteServiceName, ObservationRegistry observationRegistry) {
        return ObservableReactiveSessionFactory.wrap(session, remoteServiceName, DefaultCassandraObservationConvention.INSTANCE, observationRegistry);
    }

    public static ReactiveSession wrap(ReactiveSession session, String remoteServiceName, CassandraObservationConvention convention, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)session, (String)"CqlSession must not be null");
        Assert.notNull((Object)remoteServiceName, (String)"Remote service name must not be null");
        Assert.notNull((Object)convention, (String)"CassandraObservationConvention must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        return ObservableReactiveSession.create(session, remoteServiceName, convention, observationRegistry);
    }
}

