/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session.init;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.data.cassandra.core.cql.session.init.CannotReadScriptException;
import org.springframework.data.cassandra.core.cql.session.init.ScriptException;
import org.springframework.data.cassandra.core.cql.session.init.ScriptParseException;
import org.springframework.data.cassandra.core.cql.session.init.ScriptStatementFailedException;
import org.springframework.data.cassandra.core.cql.session.init.UncategorizedScriptException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ScriptUtils {
    public static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    public static final String FALLBACK_STATEMENT_SEPARATOR = "\n";
    public static final String EOF_STATEMENT_SEPARATOR = "^^^ END OF SCRIPT ^^^";
    public static final String DEFAULT_COMMENT_PREFIX = "--";
    public static final String[] DEFAULT_COMMENT_PREFIXES = new String[]{"--"};
    public static final String DEFAULT_BLOCK_COMMENT_START_DELIMITER = "/*";
    public static final String DEFAULT_BLOCK_COMMENT_END_DELIMITER = "*/";
    private static final Log logger = LogFactory.getLog(ScriptUtils.class);

    public static void splitCqlScript(String script, char separator, List<String> statements) throws ScriptException {
        ScriptUtils.splitCqlScript(script, String.valueOf(separator), statements);
    }

    public static void splitCqlScript(String script, String separator, List<String> statements) throws ScriptException {
        ScriptUtils.splitCqlScript(null, script, separator, DEFAULT_COMMENT_PREFIX, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER, statements);
    }

    public static void splitCqlScript(@Nullable EncodedResource resource, String script, String separator, String commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) throws ScriptException {
        Assert.hasText((String)commentPrefix, (String)"'commentPrefix' must not be null or empty");
        ScriptUtils.splitCqlScript(resource, script, separator, new String[]{commentPrefix}, blockCommentStartDelimiter, blockCommentEndDelimiter, statements);
    }

    public static void splitCqlScript(@Nullable EncodedResource resource, String script, String separator, String[] commentPrefixes, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) throws ScriptException {
        Assert.hasText((String)script, (String)"'script' must not be null or empty");
        Assert.notNull((Object)separator, (String)"'separator' must not be null");
        Assert.notEmpty((Object[])commentPrefixes, (String)"'commentPrefixes' must not be null or empty");
        for (String commentPrefix : commentPrefixes) {
            Assert.hasText((String)commentPrefix, (String)"'commentPrefixes' must not contain null or empty elements");
        }
        Assert.hasText((String)blockCommentStartDelimiter, (String)"'blockCommentStartDelimiter' must not be null or empty");
        Assert.hasText((String)blockCommentEndDelimiter, (String)"'blockCommentEndDelimiter' must not be null or empty");
        StringBuilder sb = new StringBuilder();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            int c = script.charAt(i);
            if (inEscape) {
                inEscape = false;
                sb.append((char)c);
                continue;
            }
            if (c == 92) {
                inEscape = true;
                sb.append((char)c);
                continue;
            }
            if (!inDoubleQuote && c == 39) {
                inSingleQuote = !inSingleQuote;
            } else if (!inSingleQuote && c == 34) {
                boolean bl = inDoubleQuote = !inDoubleQuote;
            }
            if (!inSingleQuote && !inDoubleQuote) {
                if (script.startsWith(separator, i)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += separator.length() - 1;
                    continue;
                }
                if (ScriptUtils.startsWithAny(script, commentPrefixes, i)) {
                    int indexOfNextNewline = script.indexOf(10, i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (script.startsWith(blockCommentStartDelimiter, i)) {
                    int indexOfCommentEnd = script.indexOf(blockCommentEndDelimiter, i);
                    if (indexOfCommentEnd > i) {
                        i = indexOfCommentEnd + blockCommentEndDelimiter.length() - 1;
                        continue;
                    }
                    throw new ScriptParseException("Missing block comment end delimiter: " + blockCommentEndDelimiter, resource);
                }
                if (c == 32 || c == 13 || c == 10 || c == 9) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = 32;
                }
            }
            sb.append((char)c);
        }
        if (StringUtils.hasText((CharSequence)sb)) {
            statements.add(sb.toString());
        }
    }

    static String readScript(EncodedResource resource) throws IOException {
        return ScriptUtils.readScript(resource, DEFAULT_COMMENT_PREFIXES, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    private static String readScript(EncodedResource resource, @Nullable String[] commentPrefixes, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(resource.getReader());){
            String string = ScriptUtils.readScript(lnr, commentPrefixes, separator, blockCommentEndDelimiter);
            return string;
        }
    }

    public static String readScript(LineNumberReader lineNumberReader, @Nullable String lineCommentPrefix, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        String[] stringArray;
        if (lineCommentPrefix != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = lineCommentPrefix;
        } else {
            stringArray = null;
        }
        String[] lineCommentPrefixes = stringArray;
        return ScriptUtils.readScript(lineNumberReader, lineCommentPrefixes, separator, blockCommentEndDelimiter);
    }

    public static String readScript(LineNumberReader lineNumberReader, @Nullable String[] lineCommentPrefixes, @Nullable String separator, @Nullable String blockCommentEndDelimiter) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (blockCommentEndDelimiter != null && currentStatement.contains(blockCommentEndDelimiter) || lineCommentPrefixes != null && !ScriptUtils.startsWithAny(currentStatement, lineCommentPrefixes, 0)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        ScriptUtils.appendSeparatorToScriptIfNecessary(scriptBuilder, separator);
        return scriptBuilder.toString();
    }

    private static void appendSeparatorToScriptIfNecessary(StringBuilder scriptBuilder, @Nullable String separator) {
        if (separator == null) {
            return;
        }
        String trimmed = separator.trim();
        if (trimmed.length() == separator.length()) {
            return;
        }
        if (scriptBuilder.lastIndexOf(trimmed) == scriptBuilder.length() - trimmed.length()) {
            scriptBuilder.append(separator.substring(trimmed.length()));
        }
    }

    private static boolean startsWithAny(String script, String[] prefixes, int offset) {
        for (String prefix : prefixes) {
            if (!script.startsWith(prefix, offset)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCqlScriptDelimiters(String script, String separator) {
        boolean inLiteral = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            char c = script.charAt(i);
            if (inEscape) {
                inEscape = false;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            if (c == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(separator, i)) continue;
            return true;
        }
        return false;
    }

    public static void executeCqlScript(CqlSession session, Resource resource) throws ScriptException {
        ScriptUtils.executeCqlScript(session, new EncodedResource(resource));
    }

    public static void executeCqlScript(CqlSession session, EncodedResource resource) throws ScriptException {
        ScriptUtils.executeCqlScript(session, resource, false, false, DEFAULT_COMMENT_PREFIX, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    public static void executeCqlScript(CqlSession session, EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops, String commentPrefix, @Nullable String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) throws ScriptException {
        ScriptUtils.executeCqlScript(session, resource, continueOnError, ignoreFailedDrops, new String[]{commentPrefix}, separator, blockCommentStartDelimiter, blockCommentEndDelimiter);
    }

    public static void executeCqlScript(CqlSession session, EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops, String[] commentPrefixes, @Nullable String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) throws ScriptException {
        try {
            String script;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing CQL script from " + String.valueOf(resource)));
            }
            long startTime = System.currentTimeMillis();
            try {
                script = ScriptUtils.readScript(resource, commentPrefixes, separator, blockCommentEndDelimiter);
            }
            catch (IOException ex) {
                throw new CannotReadScriptException(resource, (Throwable)ex);
            }
            if (separator == null) {
                separator = DEFAULT_STATEMENT_SEPARATOR;
            }
            if (!EOF_STATEMENT_SEPARATOR.equals(separator) && !ScriptUtils.containsCqlScriptDelimiters(script, separator)) {
                separator = FALLBACK_STATEMENT_SEPARATOR;
            }
            ArrayList<String> statements = new ArrayList<String>();
            ScriptUtils.splitCqlScript(resource, script, separator, commentPrefixes, blockCommentStartDelimiter, blockCommentEndDelimiter, statements);
            int stmtNumber = 0;
            for (String statement : statements) {
                ++stmtNumber;
                try {
                    ExecutionInfo executionInfo;
                    ResultSet result = session.execute(statement);
                    if (!logger.isDebugEnabled() || (executionInfo = result.getExecutionInfo()) == null) continue;
                    for (String warning : executionInfo.getWarnings()) {
                        logger.debug((Object)String.format("CQL warning ignored: [%s]", warning));
                    }
                }
                catch (RuntimeException ex) {
                    boolean dropStatement = StringUtils.startsWithIgnoreCase((String)statement.trim(), (String)"drop");
                    if (continueOnError || dropStatement && ignoreFailedDrops) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)ScriptStatementFailedException.buildErrorMessage(statement, stmtNumber, resource), (Throwable)ex);
                        continue;
                    }
                    throw new ScriptStatementFailedException(statement, stmtNumber, resource, ex);
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executed CQL script from " + String.valueOf(resource) + " in " + elapsedTime + " ms"));
            }
        }
        catch (Exception ex) {
            if (ex instanceof ScriptException) {
                throw (ScriptException)((Object)ex);
            }
            throw new UncategorizedScriptException("Failed to execute database script from resource [" + String.valueOf(resource) + "]", ex);
        }
    }
}

