/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.core.DeleteOptions;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.AsyncCqlOperations;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.domain.Slice;

public interface AsyncCassandraOperations {
    public AsyncCqlOperations getAsyncCqlOperations();

    public CassandraConverter getConverter();

    public <T> CompletableFuture<List<T>> select(String var1, Class<T> var2) throws DataAccessException;

    public <T> CompletableFuture<Void> select(String var1, Consumer<T> var2, Class<T> var3) throws DataAccessException;

    public <T> CompletableFuture<T> selectOne(String var1, Class<T> var2) throws DataAccessException;

    public CompletableFuture<AsyncResultSet> execute(Statement<?> var1) throws DataAccessException;

    public <T> CompletableFuture<List<T>> select(Statement<?> var1, Class<T> var2) throws DataAccessException;

    public <T> CompletableFuture<Slice<T>> slice(Statement<?> var1, Class<T> var2) throws DataAccessException;

    public <T> CompletableFuture<Void> select(Statement<?> var1, Consumer<T> var2, Class<T> var3) throws DataAccessException;

    public <T> CompletableFuture<T> selectOne(Statement<?> var1, Class<T> var2) throws DataAccessException;

    public <T> CompletableFuture<List<T>> select(Query var1, Class<T> var2) throws DataAccessException;

    public <T> CompletableFuture<Slice<T>> slice(Query var1, Class<T> var2) throws DataAccessException;

    public <T> CompletableFuture<Void> select(Query var1, Consumer<T> var2, Class<T> var3) throws DataAccessException;

    public <T> CompletableFuture<T> selectOne(Query var1, Class<T> var2) throws DataAccessException;

    public CompletableFuture<Boolean> update(Query var1, Update var2, Class<?> var3) throws DataAccessException;

    public CompletableFuture<Boolean> delete(Query var1, Class<?> var2) throws DataAccessException;

    public CompletableFuture<Long> count(Class<?> var1) throws DataAccessException;

    public CompletableFuture<Long> count(Query var1, Class<?> var2) throws DataAccessException;

    public CompletableFuture<Boolean> exists(Object var1, Class<?> var2) throws DataAccessException;

    public CompletableFuture<Boolean> exists(Query var1, Class<?> var2) throws DataAccessException;

    public <T> CompletableFuture<T> selectOneById(Object var1, Class<T> var2) throws DataAccessException;

    public <T> CompletableFuture<T> insert(T var1) throws DataAccessException;

    public <T> CompletableFuture<EntityWriteResult<T>> insert(T var1, InsertOptions var2) throws DataAccessException;

    public <T> CompletableFuture<T> update(T var1) throws DataAccessException;

    public <T> CompletableFuture<EntityWriteResult<T>> update(T var1, UpdateOptions var2) throws DataAccessException;

    public <T> CompletableFuture<T> delete(T var1) throws DataAccessException;

    public CompletableFuture<WriteResult> delete(Object var1, QueryOptions var2) throws DataAccessException;

    default public CompletableFuture<WriteResult> delete(Object entity, DeleteOptions options) throws DataAccessException {
        return this.delete(entity, (QueryOptions)options);
    }

    public CompletableFuture<Boolean> deleteById(Object var1, Class<?> var2) throws DataAccessException;

    public CompletableFuture<Void> truncate(Class<?> var1) throws DataAccessException;
}

