/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.querybuilder.Assignment;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.cassandra.core.QueryUtils;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class StatementFactory {
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;

    public StatementFactory(UpdateMapper updateMapper) {
        this(updateMapper, updateMapper);
    }

    public StatementFactory(QueryMapper queryMapper, UpdateMapper updateMapper) {
        Assert.notNull((Object)queryMapper, (String)"QueryMapper must not be null");
        Assert.notNull((Object)updateMapper, (String)"UpdateMapper must not be null");
        this.queryMapper = queryMapper;
        this.updateMapper = updateMapper;
    }

    protected QueryMapper getQueryMapper() {
        return this.queryMapper;
    }

    protected UpdateMapper getUpdateMapper() {
        return this.updateMapper;
    }

    public RegularStatement count(Query query2, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.count(query2, entity, entity.getTableName());
    }

    public RegularStatement count(Query query2, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Filter filter = this.getQueryMapper().getMappedObject(query2, entity);
        List<Columns.Selector> selectors = Collections.singletonList(Columns.FunctionCall.from("COUNT", 1L));
        return this.createSelect(query2, entity, filter, selectors, tableName);
    }

    public RegularStatement select(Query query2, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.select(query2, entity, entity.getTableName());
    }

    public RegularStatement select(Query query2, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull(entity, (String)"Table name must not be null");
        Filter filter = this.getQueryMapper().getMappedObject(query2, entity);
        List<Columns.Selector> selectors = this.getQueryMapper().getMappedSelectors(query2.getColumns(), entity);
        return this.createSelect(query2, entity, filter, selectors, tableName);
    }

    private Select createSelect(Query query2, CassandraPersistentEntity<?> entity, Filter filter, List<Columns.Selector> selectors, CqlIdentifier tableName) {
        Sort sort = Optional.of(query2.getSort()).map(querySort -> this.getQueryMapper().getMappedSort((Sort)querySort, entity)).orElse(Sort.unsorted());
        Select select2 = StatementFactory.createSelectAndOrder(selectors, tableName, filter, sort);
        query2.getQueryOptions().ifPresent(queryOptions -> QueryOptionsUtil.addQueryOptions(select2, queryOptions));
        if (query2.getLimit() > 0L) {
            select2.limit(Ints.checkedCast((long)query2.getLimit()));
        }
        if (query2.isAllowFiltering()) {
            select2.allowFiltering();
        }
        query2.getPagingState().ifPresent(arg_0 -> ((Select)select2).setPagingState(arg_0));
        return select2;
    }

    private static Select createSelectAndOrder(List<Columns.Selector> selectors, CqlIdentifier from, Filter filter, Sort sort) {
        Select select2;
        if (selectors.isEmpty()) {
            select2 = QueryBuilder.select().all().from(from.toCql());
        } else {
            Select.Selection selection = QueryBuilder.select();
            selectors.forEach(selector -> selector.getAlias().map(CqlIdentifier::toCql).ifPresent(arg_0 -> ((Select.SelectionOrAlias)StatementFactory.getSelection(selection, selector)).as(arg_0)));
            select2 = selection.from(from.toCql());
        }
        for (CriteriaDefinition criteriaDefinition : filter) {
            select2.where(StatementFactory.toClause(criteriaDefinition));
        }
        if (sort.isSorted()) {
            ArrayList<Ordering> orderings = new ArrayList<Ordering>();
            for (Sort.Order order : sort) {
                if (order.isAscending()) {
                    orderings.add(QueryBuilder.asc((String)order.getProperty()));
                    continue;
                }
                orderings.add(QueryBuilder.desc((String)order.getProperty()));
            }
            if (!orderings.isEmpty()) {
                select2.orderBy(orderings.toArray(new Ordering[orderings.size()]));
            }
        }
        return select2;
    }

    private static Select.SelectionOrAlias getSelection(Select.Selection selection, Columns.Selector selector) {
        if (selector instanceof Columns.FunctionCall) {
            Object[] objects = ((Columns.FunctionCall)selector).getParameters().stream().map(param -> {
                if (param instanceof Columns.ColumnSelector) {
                    return QueryBuilder.column((String)((Columns.ColumnSelector)param).getExpression());
                }
                return param;
            }).toArray();
            return selection.fcall(selector.getExpression(), objects);
        }
        return selection.column(selector.getExpression());
    }

    public RegularStatement update(Query query2, Update update, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.update(query2, update, entity, entity.getTableName());
    }

    RegularStatement update(Query query2, Update updateObj, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)updateObj, (String)"Update must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        Filter filter = this.getQueryMapper().getMappedObject(query2, entity);
        Update mappedUpdate = this.getUpdateMapper().getMappedObject(updateObj, entity);
        com.datastax.driver.core.querybuilder.Update update = StatementFactory.update(tableName, mappedUpdate, filter);
        query2.getQueryOptions().ifPresent(queryOptions -> {
            if (queryOptions instanceof WriteOptions) {
                QueryUtils.addWriteOptions(update, (WriteOptions)queryOptions);
            } else {
                QueryOptionsUtil.addQueryOptions(update, queryOptions);
            }
        });
        query2.getPagingState().ifPresent(arg_0 -> ((com.datastax.driver.core.querybuilder.Update)update).setPagingState(arg_0));
        return update;
    }

    private static com.datastax.driver.core.querybuilder.Update update(CqlIdentifier table, Update mappedUpdate, Filter filter) {
        com.datastax.driver.core.querybuilder.Update update = QueryBuilder.update((String)table.toCql());
        for (Update.AssignmentOp assignmentOp : mappedUpdate.getUpdateOperations()) {
            update.with(StatementFactory.getAssignment(assignmentOp));
        }
        for (CriteriaDefinition criteriaDefinition : filter) {
            update.where(StatementFactory.toClause(criteriaDefinition));
        }
        return update;
    }

    private static Assignment getAssignment(Update.AssignmentOp assignmentOp) {
        if (assignmentOp instanceof Update.SetOp) {
            return StatementFactory.getAssignment((Update.SetOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.RemoveOp) {
            return StatementFactory.getAssignment((Update.RemoveOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.IncrOp) {
            return StatementFactory.getAssignment((Update.IncrOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.AddToOp) {
            return StatementFactory.getAssignment((Update.AddToOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.AddToMapOp) {
            return StatementFactory.getAssignment((Update.AddToMapOp)assignmentOp);
        }
        throw new IllegalArgumentException(String.format("UpdateOp %s not supported", assignmentOp));
    }

    private static Assignment getAssignment(Update.IncrOp incrOp) {
        return incrOp.getValue().longValue() > 0L ? QueryBuilder.incr((String)incrOp.getColumnName().toCql(), (long)Math.abs(incrOp.getValue().longValue())) : QueryBuilder.decr((String)incrOp.getColumnName().toCql(), (long)Math.abs(incrOp.getValue().longValue()));
    }

    private static Assignment getAssignment(Update.SetOp updateOp) {
        if (updateOp instanceof Update.SetAtIndexOp) {
            Update.SetAtIndexOp op = (Update.SetAtIndexOp)updateOp;
            return QueryBuilder.setIdx((String)op.getColumnName().toCql(), (int)op.getIndex(), (Object)op.getValue());
        }
        if (updateOp instanceof Update.SetAtKeyOp) {
            Update.SetAtKeyOp op = (Update.SetAtKeyOp)updateOp;
            return QueryBuilder.put((String)op.getColumnName().toCql(), (Object)op.getKey(), (Object)op.getValue());
        }
        return QueryBuilder.set((String)updateOp.getColumnName().toCql(), (Object)updateOp.getValue());
    }

    private static Assignment getAssignment(Update.RemoveOp updateOp) {
        if (updateOp.getValue() instanceof Set) {
            return QueryBuilder.removeAll((String)updateOp.getColumnName().toCql(), (Set)((Set)updateOp.getValue()));
        }
        if (updateOp.getValue() instanceof List) {
            return QueryBuilder.discardAll((String)updateOp.getColumnName().toCql(), (List)((List)updateOp.getValue()));
        }
        return QueryBuilder.remove((String)updateOp.getColumnName().toCql(), (Object)updateOp.getValue());
    }

    private static Assignment getAssignment(Update.AddToOp updateOp) {
        if (updateOp.getValue() instanceof Set) {
            return QueryBuilder.addAll((String)updateOp.getColumnName().toCql(), (Set)((Set)updateOp.getValue()));
        }
        return Update.AddToOp.Mode.PREPEND.equals((Object)updateOp.getMode()) ? QueryBuilder.prependAll((String)updateOp.getColumnName().toCql(), (List)((List)updateOp.getValue())) : QueryBuilder.appendAll((String)updateOp.getColumnName().toCql(), (List)((List)updateOp.getValue()));
    }

    private static Assignment getAssignment(Update.AddToMapOp updateOp) {
        return QueryBuilder.putAll((String)updateOp.getColumnName().toCql(), updateOp.getValue());
    }

    public RegularStatement delete(Query query2, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        return this.delete(query2, entity, entity.getTableName());
    }

    public RegularStatement delete(Query query2, CassandraPersistentEntity<?> entity, CqlIdentifier tableName) {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        Filter filter = this.getQueryMapper().getMappedObject(query2, entity);
        List<String> columnNames = this.getQueryMapper().getMappedColumnNames(query2.getColumns(), entity);
        Delete delete = StatementFactory.delete(columnNames, tableName, filter);
        query2.getQueryOptions().ifPresent(queryOptions -> {
            if (queryOptions instanceof WriteOptions) {
                QueryUtils.addWriteOptions(delete, (WriteOptions)queryOptions);
            } else {
                QueryOptionsUtil.addQueryOptions(delete, queryOptions);
            }
        });
        query2.getPagingState().ifPresent(arg_0 -> ((Delete)delete).setPagingState(arg_0));
        return delete;
    }

    private static Delete delete(List<String> columnNames, CqlIdentifier from, Filter filter) {
        Delete select2;
        if (columnNames.isEmpty()) {
            select2 = QueryBuilder.delete().all().from(from.toCql());
        } else {
            Delete.Selection selection = QueryBuilder.delete();
            columnNames.forEach(arg_0 -> ((Delete.Selection)selection).column(arg_0));
            select2 = selection.from(from.toCql());
        }
        for (CriteriaDefinition criteriaDefinition : filter) {
            select2.where(StatementFactory.toClause(criteriaDefinition));
        }
        return select2;
    }

    private static Clause toClause(CriteriaDefinition criteriaDefinition) {
        CriteriaDefinition.Predicate predicate = criteriaDefinition.getPredicate();
        String columnName = criteriaDefinition.getColumnName().toCql();
        switch (predicate.getOperator().toString()) {
            case "=": {
                return QueryBuilder.eq((String)columnName, (Object)predicate.getValue());
            }
            case "!=": {
                return QueryBuilder.ne((String)columnName, (Object)predicate.getValue());
            }
            case ">": {
                return QueryBuilder.gt((String)columnName, (Object)predicate.getValue());
            }
            case ">=": {
                return QueryBuilder.gte((String)columnName, (Object)predicate.getValue());
            }
            case "<": {
                return QueryBuilder.lt((String)columnName, (Object)predicate.getValue());
            }
            case "<=": {
                return QueryBuilder.lte((String)columnName, (Object)predicate.getValue());
            }
            case "IN": {
                if (predicate.getValue() instanceof List) {
                    return QueryBuilder.in((String)columnName, (Iterable)((List)predicate.getValue()));
                }
                if (predicate.getValue() != null && predicate.getValue().getClass().isArray()) {
                    return QueryBuilder.in((String)columnName, (Object[])((Object[])predicate.getValue()));
                }
                return QueryBuilder.in((String)columnName, (Object[])new Object[]{predicate.getValue()});
            }
            case "LIKE": {
                return QueryBuilder.like((String)columnName, (Object)predicate.getValue());
            }
            case "IS NOT NULL": {
                return QueryBuilder.notNull((String)columnName);
            }
            case "CONTAINS": {
                Assert.state((predicate.getValue() != null ? 1 : 0) != 0, () -> String.format("CONTAINS value for column %s is null", columnName));
                return QueryBuilder.contains((String)columnName, (Object)predicate.getValue());
            }
            case "CONTAINS KEY": {
                Assert.state((predicate.getValue() != null ? 1 : 0) != 0, () -> String.format("CONTAINS KEY value for column %s is null", columnName));
                return QueryBuilder.containsKey((String)columnName, (Object)predicate.getValue());
            }
        }
        throw new IllegalArgumentException(String.format("Criteria %s %s %s not supported", columnName, predicate.getOperator(), predicate.getValue()));
    }
}

