/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.DriverException;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.core.cql.ReactiveResultSetExtractor;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.util.Assert;

public class ReactiveRowMapperResultSetExtractor<T>
implements ReactiveResultSetExtractor<T> {
    private final RowMapper<T> rowMapper;

    public ReactiveRowMapperResultSetExtractor(RowMapper<T> rowMapper) {
        Assert.notNull(rowMapper, (String)"RowMapper is must not be null");
        this.rowMapper = rowMapper;
    }

    @Override
    public Publisher<T> extractData(ReactiveResultSet resultSet) throws DriverException, DataAccessException {
        return resultSet.rows().handle((row, sink) -> {
            T value = this.rowMapper.mapRow((Row)row, 0);
            if (value != null) {
                sink.next(value);
            }
        });
    }
}

