/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.util.Assert;

public abstract class QueryOptionsUtil {
    public static PreparedStatement addPreparedStatementOptions(PreparedStatement preparedStatement, QueryOptions queryOptions) {
        Assert.notNull((Object)preparedStatement, (String)"PreparedStatement must not be null");
        if (queryOptions.getConsistencyLevel() != null) {
            preparedStatement.setConsistencyLevel(queryOptions.getConsistencyLevel());
        }
        if (queryOptions.getRetryPolicy() != null) {
            preparedStatement.setRetryPolicy(queryOptions.getRetryPolicy());
        }
        return preparedStatement;
    }

    public static <T extends Statement> T addQueryOptions(T statement, QueryOptions queryOptions) {
        Assert.notNull(statement, (String)"Statement must not be null");
        if (queryOptions.getConsistencyLevel() != null) {
            statement.setConsistencyLevel(queryOptions.getConsistencyLevel());
        }
        if (queryOptions.getRetryPolicy() != null) {
            statement.setRetryPolicy(queryOptions.getRetryPolicy());
        }
        if (queryOptions.getFetchSize() != null) {
            statement.setFetchSize(queryOptions.getFetchSize().intValue());
        }
        if (!queryOptions.getReadTimeout().isNegative()) {
            statement.setReadTimeoutMillis(Math.toIntExact(queryOptions.getReadTimeout().toMillis()));
        }
        if (queryOptions.getTracing() != null) {
            if (queryOptions.getTracing().booleanValue()) {
                statement.enableTracing();
            } else {
                statement.disableTracing();
            }
        }
        return statement;
    }

    public static Insert addWriteOptions(Insert insert, WriteOptions writeOptions) {
        Assert.notNull((Object)insert, (String)"Insert must not be null");
        QueryOptionsUtil.addQueryOptions(insert, writeOptions);
        if (!writeOptions.getTtl().isNegative()) {
            insert.using(QueryBuilder.ttl((int)Math.toIntExact(writeOptions.getTtl().getSeconds())));
        }
        if (writeOptions.getTimestamp() != null) {
            insert.using(QueryBuilder.timestamp((long)writeOptions.getTimestamp()));
        }
        return insert;
    }

    public static Delete addWriteOptions(Delete delete, WriteOptions writeOptions) {
        Assert.notNull((Object)delete, (String)"Update must not be null");
        QueryOptionsUtil.addQueryOptions(delete, writeOptions);
        if (writeOptions.getTimestamp() != null) {
            delete.using(QueryBuilder.timestamp((long)writeOptions.getTimestamp()));
        }
        return delete;
    }

    public static Update addWriteOptions(Update update, WriteOptions writeOptions) {
        Assert.notNull((Object)update, (String)"Update must not be null");
        QueryOptionsUtil.addQueryOptions(update, writeOptions);
        if (!writeOptions.getTtl().isNegative()) {
            update.using(QueryBuilder.ttl((int)Math.toIntExact(writeOptions.getTtl().getSeconds())));
        }
        if (writeOptions.getTimestamp() != null) {
            update.using(QueryBuilder.timestamp((long)writeOptions.getTimestamp()));
        }
        return update;
    }
}

