/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.cassandra.CassandraAuthenticationException;
import org.springframework.data.cassandra.CassandraConnectionFailureException;
import org.springframework.data.cassandra.CassandraInsufficientReplicasAvailableException;
import org.springframework.data.cassandra.CassandraInternalException;
import org.springframework.data.cassandra.CassandraInvalidConfigurationInQueryException;
import org.springframework.data.cassandra.CassandraInvalidQueryException;
import org.springframework.data.cassandra.CassandraKeyspaceExistsException;
import org.springframework.data.cassandra.CassandraQuerySyntaxException;
import org.springframework.data.cassandra.CassandraReadTimeoutException;
import org.springframework.data.cassandra.CassandraTableExistsException;
import org.springframework.data.cassandra.CassandraTraceRetrievalException;
import org.springframework.data.cassandra.CassandraTruncateException;
import org.springframework.data.cassandra.CassandraTypeMismatchException;
import org.springframework.data.cassandra.CassandraUnauthorizedException;
import org.springframework.data.cassandra.CassandraUncategorizedException;
import org.springframework.data.cassandra.CassandraWriteTimeoutException;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraExceptionTranslator
implements CqlExceptionTranslator {
    private static final Set<String> CONNECTION_FAILURE_TYPES = new HashSet<String>(Arrays.asList("NoHostAvailableException", "ConnectionException", "OperationTimedOutException", "TransportException", "BusyConnectionException", "BusyPoolException"));
    private static final Set<String> RESOURCE_FAILURE_TYPES = new HashSet<String>(Arrays.asList("ReadFailureException", "WriteFailureException", "FunctionExecutionException"));

    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException exception) {
        if (exception instanceof DataAccessException) {
            return (DataAccessException)exception;
        }
        if (!(exception instanceof DriverException)) {
            return null;
        }
        return this.translate(null, null, (DriverException)exception);
    }

    @Override
    public DataAccessException translate(@Nullable String task, @Nullable String cql, DriverException exception) {
        String message = this.buildMessage(task, cql, exception);
        if (exception instanceof AuthenticationException) {
            return new CassandraAuthenticationException(((AuthenticationException)exception).getHost(), message, (Throwable)exception);
        }
        if (exception instanceof DriverInternalError) {
            return new CassandraInternalException(message, (Throwable)exception);
        }
        if (exception instanceof InvalidTypeException) {
            return new CassandraTypeMismatchException(message, (Throwable)exception);
        }
        if (exception instanceof ReadTimeoutException) {
            return new CassandraReadTimeoutException(((ReadTimeoutException)exception).wasDataRetrieved(), message, (Throwable)exception);
        }
        if (exception instanceof WriteTimeoutException) {
            WriteType writeType = ((WriteTimeoutException)exception).getWriteType();
            return new CassandraWriteTimeoutException(writeType == null ? null : writeType.name(), message, (Throwable)exception);
        }
        if (exception instanceof TruncateException) {
            return new CassandraTruncateException(message, (Throwable)exception);
        }
        if (exception instanceof UnavailableException) {
            UnavailableException ux = (UnavailableException)exception;
            return new CassandraInsufficientReplicasAvailableException(ux.getRequiredReplicas(), ux.getAliveReplicas(), message, (Throwable)exception);
        }
        if (exception instanceof OverloadedException || exception instanceof BootstrappingException) {
            return new TransientDataAccessResourceException(message, (Throwable)exception);
        }
        if (exception instanceof AlreadyExistsException) {
            AlreadyExistsException aex = (AlreadyExistsException)exception;
            return aex.wasTableCreation() ? new CassandraTableExistsException(aex.getTable(), message, (Throwable)exception) : new CassandraKeyspaceExistsException(aex.getKeyspace(), message, (Throwable)exception);
        }
        if (exception instanceof InvalidConfigurationInQueryException) {
            return new CassandraInvalidConfigurationInQueryException(message, (Throwable)exception);
        }
        if (exception instanceof InvalidQueryException) {
            return new CassandraInvalidQueryException(message, (Throwable)exception);
        }
        if (exception instanceof SyntaxError) {
            return new CassandraQuerySyntaxException(message, (Throwable)exception);
        }
        if (exception instanceof UnauthorizedException) {
            return new CassandraUnauthorizedException(message, (Throwable)exception);
        }
        if (exception instanceof TraceRetrievalException) {
            return new CassandraTraceRetrievalException(message, (Throwable)exception);
        }
        if (exception instanceof NoHostAvailableException) {
            return new CassandraConnectionFailureException(((NoHostAvailableException)exception).getErrors(), message, (Throwable)exception);
        }
        String exceptionType = ClassUtils.getShortName((Class)ClassUtils.getUserClass(exception.getClass()));
        if (CONNECTION_FAILURE_TYPES.contains(exceptionType)) {
            Map<InetSocketAddress, Throwable> errorMap = Collections.emptyMap();
            if (exception instanceof CoordinatorException) {
                CoordinatorException cx = (CoordinatorException)exception;
                errorMap = Collections.singletonMap(cx.getAddress(), exception);
            }
            return new CassandraConnectionFailureException(errorMap, message, (Throwable)exception);
        }
        if (RESOURCE_FAILURE_TYPES.contains(exceptionType)) {
            return new DataAccessResourceFailureException(message, (Throwable)exception);
        }
        return new CassandraUncategorizedException(message, (Throwable)exception);
    }

    protected String buildMessage(@Nullable String task, @Nullable String cql, DriverException ex) {
        if (StringUtils.hasText((String)task) || StringUtils.hasText((String)cql)) {
            return task + "; CQL [" + cql + "]; " + ex.getMessage();
        }
        return ex.getMessage();
    }
}

