/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.Indexed;
import org.springframework.data.cassandra.core.mapping.PrimaryKey;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.data.cassandra.core.mapping.VerifierMappingExceptions;
import org.springframework.data.mapping.MappingException;

public class PrimaryKeyClassEntityMetadataVerifier
implements CassandraPersistentEntityMetadataVerifier {
    @Override
    public void verify(CassandraPersistentEntity<?> entity) throws MappingException {
        if (entity.getType().isInterface() || !entity.isCompositePrimaryKey()) {
            return;
        }
        ArrayList<MappingException> exceptions = new ArrayList<MappingException>();
        ArrayList idProperties = new ArrayList();
        ArrayList compositePrimaryKeys = new ArrayList();
        ArrayList partitionKeyColumns = new ArrayList();
        ArrayList primaryKeyColumns = new ArrayList();
        Class entityType = entity.getType();
        if (entity.isAnnotationPresent(Indexed.class)) {
            exceptions.add(new MappingException("@Indexed cannot be used on primary key classes"));
        }
        if (entity.isAnnotationPresent(Table.class)) {
            exceptions.add(new MappingException(String.format("Entity cannot be of type @%s and @%s", Table.class.getSimpleName(), PrimaryKeyClass.class.getSimpleName())));
        }
        if (!entityType.getSuperclass().equals(Object.class)) {
            exceptions.add(new MappingException(String.format("@%s must only extend Object", PrimaryKeyClass.class.getSimpleName())));
        }
        entity.forEach(property -> {
            if (property.isCompositePrimaryKey()) {
                compositePrimaryKeys.add(property);
            } else if (property.isIdProperty()) {
                idProperties.add(property);
            } else if (property.isClusterKeyColumn()) {
                primaryKeyColumns.add(property);
            } else if (property.isPartitionKeyColumn()) {
                partitionKeyColumns.add(property);
                primaryKeyColumns.add(property);
            }
        });
        if (!compositePrimaryKeys.isEmpty()) {
            exceptions.add(new MappingException("Composite primary keys are not allowed inside of composite primary key classes"));
        }
        if (primaryKeyColumns.isEmpty()) {
            exceptions.add(new MappingException(String.format("Composite primary key type [%1$s] has no fields annotated with @%2$s", entity.getType().getName(), PrimaryKeyColumn.class.getSimpleName())));
        }
        if (partitionKeyColumns.isEmpty()) {
            exceptions.add(new MappingException(String.format("At least one of the @%s annotations must have a type of PARTITIONED", PrimaryKeyColumn.class.getSimpleName())));
        }
        if (!idProperties.isEmpty()) {
            exceptions.add(new MappingException(String.format("Annotations @%1$s and @%2$s are invalid for type annotated with @%3$s", Id.class.getSimpleName(), PrimaryKey.class.getSimpleName(), PrimaryKeyClass.class.getSimpleName())));
        }
        if (!exceptions.isEmpty()) {
            PrimaryKeyClassEntityMetadataVerifier.fail(entity, exceptions);
        }
    }

    private static void fail(CassandraPersistentEntity<?> entity, List<MappingException> exceptions) {
        throw new VerifierMappingExceptions(entity, exceptions);
    }
}

