/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.convert.AbstractCassandraConverter;
import org.springframework.data.cassandra.core.convert.BasicCassandraRowValueProvider;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.convert.CassandraRowValueProvider;
import org.springframework.data.cassandra.core.convert.CassandraUDTValueProvider;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.convert.RowReaderPropertyAccessor;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.BasicMapId;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.core.mapping.MapId;
import org.springframework.data.cassandra.core.mapping.MapIdentifiable;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MappingCassandraConverter
extends AbstractCassandraConverter
implements CassandraConverter,
ApplicationContextAware,
BeanClassLoaderAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CassandraMappingContext mappingContext;
    @Nullable
    private ClassLoader beanClassLoader;
    private SpELContext spELContext;

    public MappingCassandraConverter() {
        this(MappingCassandraConverter.createMappingContext());
    }

    public MappingCassandraConverter(CassandraMappingContext mappingContext) {
        super((ConversionService)new DefaultConversionService());
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        this.mappingContext = mappingContext;
        this.spELContext = new SpELContext((PropertyAccessor)RowReaderPropertyAccessor.INSTANCE);
    }

    private static CassandraMappingContext createMappingContext() {
        CassandraMappingContext mappingContext = new CassandraMappingContext();
        mappingContext.setCustomConversions(new CassandraCustomConversions(Collections.emptyList()));
        return mappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public <R> R readRow(Class<R> type, Row row) {
        Class<R> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(type);
        ClassTypeInformation typeInfo = ClassTypeInformation.from(beanClassLoaderClass);
        Class rawType = typeInfo.getType();
        if (Row.class.isAssignableFrom(rawType)) {
            return (R)row;
        }
        if (this.getCustomConversions().hasCustomReadTarget(Row.class, rawType) || this.getConversionService().canConvert(Row.class, rawType)) {
            return (R)this.getConversionService().convert((Object)row, rawType);
        }
        if (typeInfo.isCollectionLike() || typeInfo.isMap()) {
            return (R)this.getConversionService().convert((Object)row, type);
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity((TypeInformation)typeInfo);
        return (R)this.readEntityFromRow(persistentEntity, row);
    }

    protected <S> S readEntityFromRow(CassandraPersistentEntity<S> entity, Row row) {
        DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator((Object)row, this.spELContext);
        BasicCassandraRowValueProvider rowValueProvider = new BasicCassandraRowValueProvider(row, expressionEvaluator);
        PersistentEntityParameterValueProvider parameterValueProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new MappingAndConvertingValueProvider(rowValueProvider), null);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)parameterValueProvider);
        this.readPropertiesFromRow(entity, rowValueProvider, (PersistentPropertyAccessor)this.getConvertingAccessor(instance, entity));
        return (S)instance;
    }

    protected <S> S readEntityFromUdt(CassandraPersistentEntity<S> entity, UDTValue udtValue) {
        DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator((Object)udtValue, this.spELContext);
        CassandraUDTValueProvider valueProvider = new CassandraUDTValueProvider(udtValue, CodecRegistry.DEFAULT_INSTANCE, expressionEvaluator);
        PersistentEntityParameterValueProvider<CassandraPersistentProperty> parameterValueProvider = this.getParameterValueProvider(entity, valueProvider);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, parameterValueProvider);
        this.readProperties(entity, valueProvider, (PersistentPropertyAccessor)this.getConvertingAccessor(instance, entity));
        return (S)instance;
    }

    private <S> PersistentEntityParameterValueProvider<CassandraPersistentProperty> getParameterValueProvider(CassandraPersistentEntity<S> entity, CassandraValueProvider valueProvider) {
        return new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new MappingAndConvertingValueProvider(valueProvider), null);
    }

    protected void readPropertiesFromRow(CassandraPersistentEntity<?> entity, CassandraRowValueProvider row, PersistentPropertyAccessor propertyAccessor) {
        this.readProperties(entity, row, propertyAccessor);
    }

    protected void readProperties(CassandraPersistentEntity<?> entity, CassandraValueProvider valueProvider, PersistentPropertyAccessor propertyAccessor) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            this.readProperty(entity, property, valueProvider, propertyAccessor);
        }
    }

    protected void readProperty(CassandraPersistentEntity<?> entity, CassandraPersistentProperty property, CassandraValueProvider valueProvider, PersistentPropertyAccessor propertyAccessor) {
        if (entity.isConstructorArgument(property)) {
            return;
        }
        if (property.isCompositePrimaryKey()) {
            CassandraPersistentEntity keyEntity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property);
            Object key = propertyAccessor.getProperty((PersistentProperty)property);
            if (key == null) {
                key = this.instantiatePrimaryKey(keyEntity, property, valueProvider);
            }
            this.readProperties(keyEntity, valueProvider, (PersistentPropertyAccessor)this.getConvertingAccessor(key, keyEntity));
            propertyAccessor.setProperty((PersistentProperty)property, key);
            return;
        }
        if (!valueProvider.hasProperty(property)) {
            return;
        }
        propertyAccessor.setProperty((PersistentProperty)property, this.getReadValue(valueProvider, property));
    }

    protected Object instantiatePrimaryKey(CassandraPersistentEntity<?> entity, CassandraPersistentProperty keyProperty, CassandraValueProvider propertyProvider) {
        return this.instantiators.getInstantiatorFor(entity).createInstance(entity, this.getParameterValueProvider(entity, propertyProvider));
    }

    public <R> R read(Class<R> type, Object row) {
        if (row instanceof Row) {
            return this.readRow(type, (Row)row);
        }
        throw new MappingException("Unknown row object " + ObjectUtils.nullSafeClassName((Object)row));
    }

    @Override
    public Object convertToColumnType(Object obj) {
        return this.convertToColumnType(obj, (TypeInformation<?>)ClassTypeInformation.from(obj.getClass()));
    }

    @Override
    public Object convertToColumnType(Object value, TypeInformation<?> typeInformation) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        Assert.notNull(typeInformation, (String)"TypeInformation must not be null");
        return value.getClass().isArray() ? value : this.getWriteValue(value, typeInformation);
    }

    public void write(Object source, Object sink) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        Class<?> beanClassLoaderClass = this.transformClassToBeanClassLoaderClass(source.getClass());
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(beanClassLoaderClass);
        this.write(source, sink, entity);
    }

    private <T> Class<T> transformClassToBeanClassLoaderClass(Class<T> entity) {
        try {
            return ClassUtils.forName((String)entity.getName(), (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException | LinkageError e) {
            return entity;
        }
    }

    @Override
    public void write(Object source, Object sink, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Value must not be null");
        if (entity == null) {
            throw new MappingException("No mapping metadata found for " + source.getClass());
        }
        if (sink instanceof Map) {
            this.writeMapFromWrapper(this.getConvertingAccessor(source, entity), (Map)sink, entity);
        } else if (sink instanceof Insert) {
            this.writeInsertFromObject(source, (Insert)sink, entity);
        } else if (sink instanceof Update) {
            this.writeUpdateFromObject(source, (Update)sink, entity);
        } else if (sink instanceof Select.Where) {
            this.writeSelectWhereFromObject(source, (Select.Where)sink, entity);
        } else if (sink instanceof Delete.Where) {
            this.writeDeleteWhereFromObject(source, (Delete.Where)sink, entity);
        } else if (sink instanceof UDTValue) {
            this.writeUDTValueWhereFromObject(this.getConvertingAccessor(source, entity), (UDTValue)sink, entity);
        } else {
            throw new MappingException("Unknown write target " + sink.getClass().getName());
        }
    }

    private void writeInsertFromObject(Object object, Insert insert, CassandraPersistentEntity<?> entity) {
        this.writeInsertFromWrapper(this.getConvertingAccessor(object, entity), insert, entity);
    }

    private void writeMapFromWrapper(ConvertingPropertyAccessor accessor, Map<String, Object> insert, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, accessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doWithProperties Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (property.isCompositePrimaryKey()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Property is a compositeKey");
                }
                if (value == null) continue;
                CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property);
                this.writeMapFromWrapper(this.getConvertingAccessor(value, compositePrimaryKey), insert, compositePrimaryKey);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding map.entry [{}] - [{}]", (Object)property.getColumnName().toCql(), value);
            }
            insert.put(property.getColumnName().toCql(), value);
        }
    }

    protected void writeInsertFromWrapper(ConvertingPropertyAccessor accessor, Insert insert, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, accessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("doWithProperties Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (property.isCompositePrimaryKey()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Property is a compositeKey");
                }
                if (value == null) continue;
                CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property);
                this.writeInsertFromWrapper(this.getConvertingAccessor(value, compositePrimaryKey), insert, compositePrimaryKey);
                continue;
            }
            if (value == null) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding insert.value [{}] - [{}]", (Object)property.getColumnName().toCql(), value);
            }
            insert.value(property.getColumnName().toCql(), value);
        }
    }

    protected void writeUpdateFromObject(Object object, Update update, CassandraPersistentEntity<?> entity) {
        this.writeUpdateFromWrapper(this.getConvertingAccessor(object, entity), update, entity);
    }

    protected void writeUpdateFromWrapper(ConvertingPropertyAccessor accessor, Update update, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, accessor);
            if (property.isCompositePrimaryKey()) {
                CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property);
                if (value == null) continue;
                this.writeUpdateFromWrapper(this.getConvertingAccessor(value, compositePrimaryKey), update, compositePrimaryKey);
                continue;
            }
            if (this.isPrimaryKeyPart(property)) {
                update.where(QueryBuilder.eq((String)property.getColumnName().toCql(), value));
                continue;
            }
            update.with(QueryBuilder.set((String)property.getColumnName().toCql(), value));
        }
    }

    protected void writeSelectWhereFromObject(Object object, Select.Where where, CassandraPersistentEntity<?> entity) {
        this.getWhereClauses(object, entity).forEach(arg_0 -> ((Select.Where)where).and(arg_0));
    }

    protected void writeDeleteWhereFromObject(Object object, Delete.Where where, CassandraPersistentEntity<?> entity) {
        this.getWhereClauses(object, entity).forEach(arg_0 -> ((Delete.Where)where).and(arg_0));
    }

    protected void writeUDTValueWhereFromObject(ConvertingPropertyAccessor accessor, UDTValue udtValue, CassandraPersistentEntity<?> entity) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            Object value = this.getWriteValue(property, accessor);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writeUDTValueWhereFromObject Property.type {}, Property.value {}", (Object)property.getType().getName(), value);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding udt.value [{}] - [{}]", (Object)property.getColumnName().toCql(), value);
            }
            TypeCodec typeCodec = CodecRegistry.DEFAULT_INSTANCE.codecFor(this.getMappingContext().getDataType(property));
            udtValue.set(property.getColumnName().toCql(), value, typeCodec);
        }
    }

    private Collection<Clause> getWhereClauses(Object source, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)source, (String)"Id source must not be null");
        Object id = this.extractId(source, entity);
        Assert.notNull((Object)id, (String)String.format("No Id value found in object %s", source));
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        CassandraPersistentProperty compositeIdProperty = null;
        if (idProperty != null && idProperty.isCompositePrimaryKey()) {
            compositeIdProperty = idProperty;
        }
        if (id instanceof MapId) {
            CassandraPersistentEntity whereEntity = compositeIdProperty != null ? (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(compositeIdProperty) : entity;
            return this.getWhereClauses((MapId)MapId.class.cast(id), whereEntity);
        }
        if (idProperty == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot obtain where clauses for entity [%s] using [%s]", entity.getName(), source));
        }
        if (compositeIdProperty != null) {
            if (!ClassUtils.isAssignableValue((Class)compositeIdProperty.getType(), (Object)id)) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot use [%s] as composite Id for [%s]", id, entity.getName()));
            }
            CassandraPersistentEntity compositePrimaryKey = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(compositeIdProperty);
            return this.getWhereClauses(this.getConvertingAccessor(id, compositePrimaryKey), compositePrimaryKey);
        }
        Class<?> targetType = this.getTargetType(idProperty);
        return Collections.singleton(QueryBuilder.eq((String)idProperty.getColumnName().toCql(), (Object)this.getPotentiallyConvertedSimpleValue(id, targetType)));
    }

    @Nullable
    private Object extractId(Object source, CassandraPersistentEntity<?> entity) {
        if (ClassUtils.isAssignableValue((Class)entity.getType(), (Object)source)) {
            return this.getId(source, entity);
        }
        if (source instanceof MapId) {
            return source;
        }
        if (source instanceof MapIdentifiable) {
            return ((MapIdentifiable)source).getMapId();
        }
        return source;
    }

    private Collection<Clause> getWhereClauses(ConvertingPropertyAccessor accessor, CassandraPersistentEntity<?> entity) {
        Assert.isTrue((boolean)entity.isCompositePrimaryKey(), (String)String.format("Entity [%s] is not a composite primary key", entity.getName()));
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            TypeCodec<Object> codec = this.getCodec(property);
            Object value = accessor.getProperty((PersistentProperty)property, codec.getJavaType().getRawType());
            clauses.add(QueryBuilder.eq((String)property.getColumnName().toCql(), (Object)value));
        }
        return clauses;
    }

    private Collection<Clause> getWhereClauses(MapId id, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)id, (String)"MapId must not be null");
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (Map.Entry entry : id.entrySet()) {
            CassandraPersistentProperty persistentProperty = (CassandraPersistentProperty)entity.getPersistentProperty((String)entry.getKey());
            if (persistentProperty == null) {
                throw new IllegalArgumentException(String.format("MapId contains references [%s] that is an unknown property of [%s]", entry.getKey(), entity.getName()));
            }
            Object writeValue = this.getWriteValue(entry.getValue(), persistentProperty.getTypeInformation());
            clauses.add(QueryBuilder.eq((String)persistentProperty.getColumnName().toCql(), (Object)writeValue));
        }
        return clauses;
    }

    @Override
    public Object getId(Object object, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)object, (String)"Object instance must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        ConvertingPropertyAccessor propertyAccessor = this.getConvertingAccessor(object, entity);
        Assert.isTrue((boolean)entity.getType().isAssignableFrom(object.getClass()), (String)String.format("Given instance of type [%s] is not of compatible expected type [%s]", object.getClass().getName(), entity.getType().getName()));
        if (object instanceof MapIdentifiable) {
            return ((MapIdentifiable)object).getMapId();
        }
        CassandraPersistentProperty idProperty = (CassandraPersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            return propertyAccessor.getProperty((PersistentProperty)idProperty, idProperty.isCompositePrimaryKey() ? idProperty.getType() : this.getTargetType(idProperty));
        }
        MapId id = BasicMapId.id();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (!property.isPrimaryKeyColumn()) continue;
            id.with(property.getName(), this.getWriteValue(property, propertyAccessor));
        }
        return id;
    }

    private ConvertingPropertyAccessor getConvertingAccessor(Object source, CassandraPersistentEntity<?> entity) {
        PersistentPropertyAccessor propertyAccessor = source instanceof PersistentPropertyAccessor ? (PersistentPropertyAccessor)source : entity.getPropertyAccessor(source);
        return new ConvertingPropertyAccessor(propertyAccessor, this.getConversionService());
    }

    private boolean isPrimaryKeyPart(CassandraPersistentProperty property) {
        return property.isCompositePrimaryKey() || property.isPrimaryKeyColumn() || property.isIdProperty();
    }

    private Class<?> getTargetType(CassandraPersistentProperty property) {
        return this.getCustomConversions().getCustomWriteTarget(property.getType()).orElseGet(() -> {
            if (property.isAnnotationPresent(CassandraType.class)) {
                return this.getPropertyTargetType(property);
            }
            if (property.isCompositePrimaryKey() || this.getCustomConversions().isSimpleType(property.getType()) || property.isCollectionLike()) {
                return property.getType();
            }
            return this.getPropertyTargetType(property);
        });
    }

    private Class<?> getPropertyTargetType(CassandraPersistentProperty property) {
        DataType dataType = this.getMappingContext().getDataType(property);
        if (dataType instanceof UserType) {
            return property.getType();
        }
        TypeCodec codec = CodecRegistry.DEFAULT_INSTANCE.codecFor(this.getMappingContext().getDataType(property));
        return codec.getJavaType().getRawType();
    }

    @Nullable
    private <T> T getWriteValue(CassandraPersistentProperty property, ConvertingPropertyAccessor accessor) {
        return (T)this.getWriteValue(accessor.getProperty((PersistentProperty)property, this.getTargetType(property)), property.getTypeInformation());
    }

    @Nullable
    private Object getWriteValue(@Nullable Object value, @Nullable TypeInformation<?> typeInformation) {
        Class requestedTargetType;
        if (value == null) {
            return null;
        }
        Class clazz = requestedTargetType = typeInformation != null ? typeInformation.getType() : Object.class;
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass(), requestedTargetType)) {
            return this.getConversionService().convert(value, this.getCustomConversions().getCustomWriteTarget(value.getClass(), requestedTargetType).orElse(requestedTargetType));
        }
        if (this.getCustomConversions().hasCustomWriteTarget(value.getClass())) {
            return this.getConversionService().convert(value, (Class)this.getCustomConversions().getCustomWriteTarget(value.getClass()).get());
        }
        if (this.getCustomConversions().isSimpleType(value.getClass())) {
            return this.getPotentiallyConvertedSimpleValue(value, requestedTargetType);
        }
        ClassTypeInformation type = typeInformation != null ? typeInformation : ClassTypeInformation.from(value.getClass());
        TypeInformation actualType = type.getRequiredActualType();
        if (value instanceof Collection) {
            Collection original = (Collection)value;
            Collection converted = CollectionFactory.createCollection(MappingCassandraConverter.getCollectionType(type), (int)original.size());
            for (Object element : original) {
                converted.add(this.convertToColumnType(element, actualType));
            }
            return converted;
        }
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(actualType.getType());
        if (entity != null && entity.isUserDefinedType()) {
            UDTValue udtValue = entity.getUserType().newValue();
            this.write(value, udtValue, entity);
            return udtValue;
        }
        return value;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleValue(@Nullable Object value, @Nullable Class<?> requestedTargetType) {
        if (value == null) {
            return null;
        }
        if (Enum.class.isAssignableFrom(value.getClass())) {
            if (requestedTargetType != null && !requestedTargetType.isEnum() && this.getConversionService().canConvert(value.getClass(), requestedTargetType)) {
                return this.getConversionService().convert(value, requestedTargetType);
            }
            return ((Enum)value).name();
        }
        return value;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(@Nullable Object value, @Nullable Class<?> target) {
        if (value == null || target == null || target.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (this.getCustomConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.getConversionService().convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.getConversionService().convert(value, target);
    }

    private static Class<?> getCollectionType(TypeInformation<?> type) {
        if (type.getType().isInterface()) {
            return type.getType();
        }
        if (ClassTypeInformation.LIST.isAssignableFrom(type)) {
            return ClassTypeInformation.LIST.getType();
        }
        if (ClassTypeInformation.SET.isAssignableFrom(type)) {
            return ClassTypeInformation.SET.getType();
        }
        if (!type.isCollectionLike()) {
            return ClassTypeInformation.LIST.getType();
        }
        return type.getType();
    }

    @Nullable
    protected Object getReadValue(CassandraValueProvider row, CassandraPersistentProperty property) {
        if (property.isCompositePrimaryKey()) {
            CassandraPersistentEntity keyEntity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property);
            return this.instantiatePrimaryKey(keyEntity, property, row);
        }
        Object value = row.getPropertyValue(property);
        if (value == null) {
            return null;
        }
        if (this.getCustomConversions().hasCustomWriteTarget(property.getActualType()) && property.isCollectionLike() && value instanceof Collection) {
            Collection original = (Collection)value;
            Collection converted = CollectionFactory.createCollection((Class)property.getType(), (int)original.size());
            for (Object element : original) {
                converted.add(this.getConversionService().convert(element, property.getActualType()));
            }
            return converted;
        }
        if (property.isCollectionLike() && value instanceof Collection) {
            return this.readCollectionOrArray(property.getTypeInformation(), (Collection)value);
        }
        BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(property.getActualType());
        if (persistentEntity != null && persistentEntity.isUserDefinedType() && value instanceof UDTValue) {
            return this.readEntityFromUdt(persistentEntity, (UDTValue)value);
        }
        return this.getPotentiallyConvertedSimpleRead(value, property.getType());
    }

    @Nullable
    private Object readCollectionOrArray(TypeInformation<?> targetType, Collection<?> sourceValue) {
        ArrayList<Object> items;
        Assert.notNull(targetType, (String)"Target type must not be null!");
        Class<List> collectionType = targetType.getType();
        TypeInformation componentType = targetType.getComponentType();
        Class rawComponentType = componentType != null ? componentType.getType() : List.class;
        collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
        Collection<Object> collection = items = targetType.getType().isArray() ? new ArrayList<Object>() : CollectionFactory.createCollection(collectionType, (Class)rawComponentType, (int)sourceValue.size());
        if (sourceValue.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, collectionType);
        }
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.getMappingContext().getPersistentEntity(rawComponentType);
        if (entity != null && entity.isUserDefinedType()) {
            for (Object udtValue : sourceValue) {
                items.add(this.readEntityFromUdt(entity, (UDTValue)udtValue));
            }
        } else {
            for (Object item : sourceValue) {
                items.add(this.getPotentiallyConvertedSimpleRead(item, rawComponentType));
            }
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    private TypeCodec<Object> getCodec(CassandraPersistentProperty property) {
        return CodecRegistry.DEFAULT_INSTANCE.codecFor(this.mappingContext.getDataType(property));
    }

    class MappingAndConvertingValueProvider
    implements CassandraValueProvider {
        private final CassandraValueProvider parent;

        @Override
        public boolean hasProperty(CassandraPersistentProperty property) {
            return this.parent.hasProperty(property);
        }

        @Nullable
        public <T> T getPropertyValue(CassandraPersistentProperty property) {
            return (T)MappingCassandraConverter.this.getReadValue(this.parent, property);
        }

        public MappingAndConvertingValueProvider(CassandraValueProvider parent) {
            this.parent = parent;
        }
    }
}

