/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.zookeeper.config.ZookeeperConfigProperties;
import org.springframework.cloud.zookeeper.config.ZookeeperPropertySource;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ReflectionUtils;

public class ZookeeperPropertySourceLocator
implements PropertySourceLocator {
    private ZookeeperConfigProperties properties;
    private CuratorFramework curator;
    private List<String> contexts;
    private static final Log log = LogFactory.getLog(ZookeeperPropertySourceLocator.class);

    public ZookeeperPropertySourceLocator(CuratorFramework curator, ZookeeperConfigProperties properties) {
        this.curator = curator;
        this.properties = properties;
    }

    public List<String> getContexts() {
        return this.contexts;
    }

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            String appName = env.getProperty("spring.application.name");
            if (appName == null) {
                appName = "application";
                log.warn((Object)"spring.application.name is not set. Using default of 'application'");
            }
            List<String> profiles = Arrays.asList(env.getActiveProfiles());
            String root = this.properties.getRoot();
            this.contexts = new ArrayList<String>();
            String defaultContext = root + "/" + this.properties.getDefaultContext();
            this.contexts.add(defaultContext);
            this.addProfiles(this.contexts, defaultContext, profiles);
            StringBuilder baseContext = new StringBuilder(root);
            if (!appName.startsWith("/")) {
                baseContext.append("/");
            }
            baseContext.append(appName);
            this.contexts.add(baseContext.toString());
            this.addProfiles(this.contexts, baseContext.toString(), profiles);
            CompositePropertySource composite = new CompositePropertySource("zookeeper");
            Collections.reverse(this.contexts);
            for (String propertySourceContext : this.contexts) {
                try {
                    PropertySource<CuratorFramework> propertySource = this.create(propertySourceContext);
                    composite.addPropertySource(propertySource);
                }
                catch (Exception e) {
                    if (this.properties.isFailFast()) {
                        ReflectionUtils.rethrowRuntimeException((Throwable)e);
                        continue;
                    }
                    log.warn((Object)("Unable to load zookeeper config from " + propertySourceContext), (Throwable)e);
                }
            }
            return composite;
        }
        return null;
    }

    @PreDestroy
    public void destroy() {
    }

    private PropertySource<CuratorFramework> create(String context) {
        return new ZookeeperPropertySource(context, this.curator);
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile);
        }
    }
}

