/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.launcher;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.cloud.task.launcher.TaskLaunchRequest;
import org.springframework.core.io.Resource;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.Assert;

@EnableBinding(value={Sink.class})
public class TaskLauncherSink {
    private static final Logger logger = LoggerFactory.getLogger(TaskLauncherSink.class);
    @Autowired
    public TaskLauncher taskLauncher;
    @Autowired
    private DelegatingResourceLoader resourceLoader;

    @ServiceActivator(inputChannel="input")
    public void taskLauncherSink(TaskLaunchRequest taskLaunchRequest) throws Exception {
        this.launchTask(taskLaunchRequest);
    }

    private void launchTask(TaskLaunchRequest taskLaunchRequest) {
        Assert.notNull((Object)this.taskLauncher, (String)"TaskLauncher has not been initialized");
        logger.info("Launching Task for the following uri " + taskLaunchRequest.getUri());
        Resource resource = this.resourceLoader.getResource(taskLaunchRequest.getUri());
        AppDefinition definition = new AppDefinition(taskLaunchRequest.getApplicationName(), taskLaunchRequest.getEnvironmentProperties());
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, taskLaunchRequest.getDeploymentProperties(), taskLaunchRequest.getCommandlineArguments());
        this.taskLauncher.launch(request);
    }
}

