/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2.sender;

import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.zipkin2.sender.ZipkinSenderCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import zipkin2.reporter.Sender;
import zipkin2.reporter.kafka11.KafkaSender;

@Configuration
@ConditionalOnClass(value={ByteArraySerializer.class})
@ConditionalOnMissingBean(name={"zipkinSender"})
@Conditional(value={ZipkinSenderCondition.class})
@ConditionalOnProperty(value={"spring.zipkin.sender.type"}, havingValue="kafka")
class ZipkinKafkaSenderConfiguration {
    ZipkinKafkaSenderConfiguration() {
    }

    @Configuration
    @EnableConfigurationProperties(value={KafkaProperties.class})
    static class ZipkinKafkaSenderBeanConfiguration {
        @Value(value="${spring.zipkin.kafka.topic:zipkin}")
        private String topic;

        ZipkinKafkaSenderBeanConfiguration() {
        }

        static String join(List<?> parts) {
            StringBuilder to = new StringBuilder();
            int length = parts.size();
            for (int i = 0; i < length; ++i) {
                to.append(parts.get(i));
                if (i + 1 >= length) continue;
                to.append(',');
            }
            return to.toString();
        }

        @Bean(value={"zipkinSender"})
        Sender kafkaSender(KafkaProperties config) {
            Map properties = config.buildProducerProperties();
            properties.put("key.serializer", ByteArraySerializer.class.getName());
            properties.put("value.serializer", ByteArraySerializer.class.getName());
            Object bootstrapServers = properties.get("bootstrap.servers");
            if (bootstrapServers instanceof List) {
                properties.put("bootstrap.servers", ZipkinKafkaSenderBeanConfiguration.join((List)bootstrapServers));
            }
            return KafkaSender.newBuilder().topic(this.topic).overrides(properties).build();
        }
    }
}

