/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.trace.Span;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.springframework.cloud.sleuth.otel.bridge.EventPublishingContextWrapper;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class Slf4jApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private static final Log log = LogFactory.getLog(Slf4jApplicationListener.class);

    private void onScopeAttached(EventPublishingContextWrapper.ScopeAttachedEvent event) {
        Span span;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Got scope changed event [" + (Object)((Object)event) + "]"));
        }
        if ((span = event.getSpan()) != null) {
            MDC.put((String)"traceId", (String)span.getSpanContext().getTraceId());
            MDC.put((String)"spanId", (String)span.getSpanContext().getSpanId());
        }
    }

    private void onScopeRestored(EventPublishingContextWrapper.ScopeRestoredEvent event) {
        Span span;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Got scope restored event [" + (Object)((Object)event) + "]"));
        }
        if ((span = event.getSpan()) != null) {
            MDC.put((String)"traceId", (String)span.getSpanContext().getTraceId());
            MDC.put((String)"spanId", (String)span.getSpanContext().getSpanId());
        }
    }

    private void onScopeClosed(EventPublishingContextWrapper.ScopeClosedEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Got scope closed event [" + (Object)((Object)event) + "]"));
        }
        MDC.remove((String)"traceId");
        MDC.remove((String)"spanId");
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof EventPublishingContextWrapper.ScopeAttachedEvent) {
            this.onScopeAttached((EventPublishingContextWrapper.ScopeAttachedEvent)event);
        } else if (event instanceof EventPublishingContextWrapper.ScopeClosedEvent) {
            this.onScopeClosed((EventPublishingContextWrapper.ScopeClosedEvent)event);
        } else if (event instanceof EventPublishingContextWrapper.ScopeRestoredEvent) {
            this.onScopeRestored((EventPublishingContextWrapper.ScopeRestoredEvent)event);
        }
    }
}

