/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.session;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.instrument.session.SleuthSessionSpan;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;

class TraceSessionRepository
implements SessionRepository {
    private static final Log log = LogFactory.getLog(TraceSessionRepository.class);
    private final SessionRepository delegate;
    protected final Tracer tracer;

    TraceSessionRepository(Tracer tracer, SessionRepository delegate) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    public Session createSession() {
        return this.wrap(SleuthSessionSpan.SESSION_CREATE_SPAN, () -> ((SessionRepository)this.delegate).createSession());
    }

    private <T> T wrap(SleuthSessionSpan sessionSpan, Supplier<T> supplier) {
        AssertingSpan span = this.newSpan(sessionSpan);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wrapping call in a span with name [" + span.getDocumentedSpan().getName() + "] - [" + span + "]"));
        }
        try {
            T t;
            block10: {
                Tracer.SpanInScope ws = this.tracer.withSpan((Span)span.start());
                try {
                    t = supplier.get();
                    if (ws == null) break block10;
                }
                catch (Throwable throwable) {
                    if (ws != null) {
                        try {
                            ws.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ws.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    private void wrap(SleuthSessionSpan sessionSpan, Runnable runnable) {
        this.wrap(sessionSpan, () -> {
            runnable.run();
            return null;
        });
    }

    private AssertingSpan newSpan(SleuthSessionSpan sessionCreateSpan) {
        return AssertingSpan.of((DocumentedSpan)sessionCreateSpan, (Span)this.tracer.nextSpan()).name(sessionCreateSpan.getName());
    }

    public void save(Session session) {
        this.wrap(SleuthSessionSpan.SESSION_SAVE_SPAN, () -> this.delegate.save(session));
    }

    public Session findById(String id) {
        return this.wrap(SleuthSessionSpan.SESSION_FIND_SPAN, () -> this.delegate.findById(id));
    }

    public void deleteById(String id) {
        this.wrap(SleuthSessionSpan.SESSION_DELETE_SPAN, () -> this.delegate.deleteById(id));
    }
}

