/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.cassandra.CassandraSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.cassandra.TraceCqlSessionInterceptor;
import org.springframework.cloud.sleuth.instrument.cassandra.TraceStatement;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.ReactiveSession;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class TraceReactiveSession
implements ReactiveSession {
    private final ReactiveSession delegate;
    private final BeanFactory beanFactory;
    private Tracer tracer;
    private CurrentTraceContext currentTraceContext;

    TraceReactiveSession(ReactiveSession delegate, BeanFactory beanFactory) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    public static ReactiveSession create(ReactiveSession session, BeanFactory beanFactory) {
        return new TraceReactiveSession(session, beanFactory);
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public DriverContext getContext() {
        return this.delegate.getContext();
    }

    public Optional<CqlIdentifier> getKeyspace() {
        return this.delegate.getKeyspace();
    }

    public Metadata getMetadata() {
        return this.delegate.getMetadata();
    }

    public Mono<ReactiveResultSet> execute(String cql) {
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)cql));
    }

    public Mono<ReactiveResultSet> execute(String cql, Object ... objects) {
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)cql, (Object[])objects));
    }

    public Mono<ReactiveResultSet> execute(String cql, Map<String, Object> map) {
        return this.execute((Statement<?>)SimpleStatement.newInstance((String)cql, map));
    }

    public Mono<ReactiveResultSet> execute(Statement<?> statement) {
        return Mono.deferContextual(contextView -> {
            Span span = ReactorSleuth.spanFromContext(this.tracer(), this.currentTraceContext(), contextView);
            return this.delegate.execute(this.proxiedStatement(span, statement, "execute"));
        }).contextWrite(context -> ReactorSleuth.putSpanInScope(this.tracer(), context, this.createSpan((ContextView)context)));
    }

    public Mono<PreparedStatement> prepare(String cql) {
        return this.prepare(SimpleStatement.newInstance((String)cql));
    }

    public Mono<PreparedStatement> prepare(SimpleStatement statement) {
        return Mono.deferContextual(contextView -> {
            Span span = ReactorSleuth.spanFromContext(this.tracer(), this.currentTraceContext(), contextView);
            return this.delegate.prepare((SimpleStatement)this.proxiedStatement(span, (Statement<?>)statement, "prepare"));
        }).contextWrite(context -> ReactorSleuth.putSpanInScope(this.tracer(), context, this.createSpan((ContextView)context)));
    }

    private Statement<?> proxiedStatement(Span span, Statement<?> statement, String defaultName) {
        Statement<?> proxied = TraceStatement.createProxy(span, statement);
        ((CassandraSpanCustomizer)proxied).customizeSpan(defaultName);
        return proxied;
    }

    public void close() {
        this.delegate.close();
    }

    private Span createSpan(ContextView contextView) {
        return TraceCqlSessionInterceptor.cassandraClientSpan(this.spanBuilder(contextView), this.getContext().getSessionName(), Optional.empty());
    }

    private Span.Builder spanBuilder(ContextView contextView) {
        Span.Builder spanBuilder = this.tracer().spanBuilder();
        if (contextView.hasKey(TraceContext.class)) {
            return spanBuilder.setParent((TraceContext)contextView.get(TraceContext.class));
        }
        if (contextView.hasKey(Span.class)) {
            return spanBuilder.setParent(((Span)contextView.get(Span.class)).context());
        }
        Span span = this.tracer().currentSpan();
        if (span != null) {
            return spanBuilder.setParent(span.context());
        }
        return spanBuilder;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.beanFactory.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }
}

