/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.rxjava;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import rx.functions.Action0;
import rx.plugins.RxJavaErrorHandler;
import rx.plugins.RxJavaObservableExecutionHook;
import rx.plugins.RxJavaPlugins;
import rx.plugins.RxJavaSchedulersHook;

public class SleuthRxJavaSchedulersHook
extends RxJavaSchedulersHook {
    private static final Log log = LogFactory.getLog(SleuthRxJavaSchedulersHook.class);
    private static final String RXJAVA_COMPONENT = "rxjava";
    private final Tracer tracer;
    private final List<Pattern> threadsToIgnore;
    private RxJavaSchedulersHook delegate;

    public SleuthRxJavaSchedulersHook(Tracer tracer, List<String> threadsToIgnore) {
        this.tracer = tracer;
        this.threadsToIgnore = this.toPatternList(threadsToIgnore);
        try {
            this.delegate = RxJavaPlugins.getInstance().getSchedulersHook();
            if (this.delegate instanceof SleuthRxJavaSchedulersHook) {
                return;
            }
            RxJavaErrorHandler errorHandler = RxJavaPlugins.getInstance().getErrorHandler();
            RxJavaObservableExecutionHook observableExecutionHook = RxJavaPlugins.getInstance().getObservableExecutionHook();
            this.logCurrentStateOfRxJavaPlugins(errorHandler, observableExecutionHook);
            RxJavaPlugins.getInstance().reset();
            RxJavaPlugins.getInstance().registerSchedulersHook((RxJavaSchedulersHook)this);
            RxJavaPlugins.getInstance().registerErrorHandler(errorHandler);
            RxJavaPlugins.getInstance().registerObservableExecutionHook(observableExecutionHook);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to register Sleuth RxJava SchedulersHook", (Throwable)ex);
        }
    }

    private List<Pattern> toPatternList(List<String> threadsToIgnore) {
        if (threadsToIgnore == null || threadsToIgnore.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(threadsToIgnore.size());
        for (String thread : threadsToIgnore) {
            patterns.add(Pattern.compile(thread));
        }
        return Collections.unmodifiableList(patterns);
    }

    private void logCurrentStateOfRxJavaPlugins(RxJavaErrorHandler errorHandler, RxJavaObservableExecutionHook observableExecutionHook) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current RxJava plugins configuration is [schedulersHook [" + this.delegate + "],errorHandler [" + errorHandler + "],observableExecutionHook [" + observableExecutionHook + "],]"));
            log.debug((Object)"Registering Sleuth RxJava Schedulers Hook.");
        }
    }

    public Action0 onSchedule(Action0 action) {
        Action0 wrappedAction;
        if (action instanceof TraceAction) {
            return action;
        }
        Action0 action0 = wrappedAction = this.delegate != null ? this.delegate.onSchedule(action) : action;
        if (wrappedAction instanceof TraceAction) {
            return action;
        }
        return super.onSchedule((Action0)new TraceAction(this.tracer, wrappedAction, this.threadsToIgnore));
    }

    static class TraceAction
    implements Action0 {
        private static final String THREAD_NAME_KEY = "thread";
        private final Action0 actual;
        private final Tracer tracer;
        private final Span parent;
        private final List<Pattern> threadsToIgnore;

        TraceAction(Tracer tracer, Action0 actual, List<Pattern> threadsToIgnore) {
            this.tracer = tracer;
            this.threadsToIgnore = threadsToIgnore;
            this.parent = this.tracer.currentSpan();
            this.actual = actual;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call() {
            String threadName = Thread.currentThread().getName();
            for (Pattern threadToIgnore : this.threadsToIgnore) {
                if (!threadToIgnore.matcher(threadName).matches()) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Thread with name [%s] matches the regex [%s]. A span will not be created for this Thread.", threadName, threadToIgnore));
                }
                this.actual.call();
                return;
            }
            Span span = this.parent;
            boolean created = false;
            if (span == null) {
                span = this.tracer.nextSpan().name(SleuthRxJavaSchedulersHook.RXJAVA_COMPONENT).start();
                span.tag(THREAD_NAME_KEY, Thread.currentThread().getName());
                created = true;
            }
            try (Tracer.SpanInScope ws = this.tracer.withSpan(span);){
                this.actual.call();
            }
            finally {
                if (created) {
                    span.end();
                }
            }
        }
    }
}

