/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.annotation;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.NewSpanParser;
import org.springframework.cloud.sleuth.internal.SpanNameUtil;
import org.springframework.util.StringUtils;

public class DefaultSpanCreator
implements NewSpanParser {
    private static final Log log = LogFactory.getLog(DefaultSpanCreator.class);

    public void parse(MethodInvocation pjp, NewSpan newSpan, Span span) {
        String name = newSpan == null || StringUtils.isEmpty((Object)newSpan.name()) ? pjp.getMethod().getName() : newSpan.name();
        String changedName = SpanNameUtil.toLowerHyphen(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("For the class [" + pjp.getThis().getClass() + "] method [" + pjp.getMethod().getName() + "] will name the span [" + changedName + "]"));
        }
        span.name(changedName);
    }
}

