/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.TracingJmsListenerEndpointRegistry;

public class TracingJmsBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    public TracingJmsBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return this.wrap(bean);
    }

    private Object wrap(Object bean) {
        if (this.typeMatches(bean)) {
            return new TracingJmsListenerEndpointRegistry((JmsListenerEndpointRegistry)bean, this.beanFactory);
        }
        return bean;
    }

    private boolean typeMatches(Object bean) {
        return bean instanceof JmsListenerEndpointRegistry && !(bean instanceof TracingJmsListenerEndpointRegistry);
    }
}

