/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.internal.propagation.StringPropagationAdapter;
import brave.propagation.B3Propagation;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.aws.AWSPropagation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageManager;
import org.springframework.cloud.sleuth.brave.bridge.W3CPropagation;
import org.springframework.cloud.sleuth.brave.propagation.PropagationType;

class CompositePropagationFactory
extends Propagation.Factory
implements Propagation<String> {
    private final Map<PropagationType, Propagation<String>> mapping = new HashMap<PropagationType, Propagation<String>>();
    private final List<PropagationType> types;

    CompositePropagationFactory(BraveBaggageManager braveBaggageManager, List<String> localFields, List<PropagationType> types) {
        this.types = types;
        this.mapping.put(PropagationType.AWS, (Propagation<String>)AWSPropagation.FACTORY.get());
        this.mapping.put(PropagationType.B3, (Propagation<String>)B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build().get());
        this.mapping.put(PropagationType.W3C, new W3CPropagation(braveBaggageManager, localFields));
        this.mapping.put(PropagationType.CUSTOM, NoOpPropagation.INSTANCE);
    }

    public List<String> keys() {
        return this.types.stream().map(this.mapping::get).flatMap(p -> p.keys().stream()).collect(Collectors.toList());
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return (traceContext, request) -> this.types.stream().map(this.mapping::get).forEach(p -> p.injector(setter).inject(traceContext, request));
    }

    public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
        return request -> {
            for (PropagationType type : this.types) {
                TraceContextOrSamplingFlags extract;
                Propagation<String> propagator = this.mapping.get((Object)type);
                if (propagator == null || propagator == NoOpPropagation.INSTANCE || (extract = propagator.extractor(getter).extract(request)) == TraceContextOrSamplingFlags.EMPTY) continue;
                return extract;
            }
            return TraceContextOrSamplingFlags.EMPTY;
        };
    }

    public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
        return StringPropagationAdapter.create((Propagation)this, keyFactory);
    }

    private static class NoOpPropagation
    implements Propagation<String> {
        static final NoOpPropagation INSTANCE = new NoOpPropagation();

        private NoOpPropagation() {
        }

        public List<String> keys() {
            return Collections.emptyList();
        }

        public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
            return (traceContext, request) -> {};
        }

        public <R> TraceContext.Extractor<R> extractor(Propagation.Getter<R, String> getter) {
            return request -> TraceContextOrSamplingFlags.EMPTY;
        }
    }
}

