/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.redis;

import brave.sampler.Sampler;
import io.lettuce.core.tracing.Tracing;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.brave.instrument.redis.TraceRedisProperties;
import org.springframework.cloud.sleuth.instrument.redis.TraceLettuceClientResourcesBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.redis.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={Tracing.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceRedisProperties.class})
public class TraceRedisAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.sleuth.redis.legacy.enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnBean(value={Tracing.class})
    static class LettuceConfiguration {
        LettuceConfiguration() {
        }

        @Bean
        @ConditionalOnClass(name={"brave.sampler.Sampler"})
        TraceLettuceClientResourcesBuilderCustomizer braveTraceLettuceClientResourcesBuilderCustomizer(Tracing tracing, Sampler sampler) {
            this.eagerlyInitializePotentiallyRefreshScopeSampler(sampler);
            return new TraceLettuceClientResourcesBuilderCustomizer(tracing);
        }

        @Bean
        @ConditionalOnMissingClass(value={"brave.sampler.Sampler"})
        TraceLettuceClientResourcesBuilderCustomizer otherTracersTraceLettuceClientResourcesBuilderCustomizer(Tracing tracing) {
            return new TraceLettuceClientResourcesBuilderCustomizer(tracing);
        }

        private void eagerlyInitializePotentiallyRefreshScopeSampler(Sampler sampler) {
            sampler.isSampled(0L);
        }
    }
}

