/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave.instrument.mongodb;

import brave.Tracing;
import brave.mongodb.MongoDBTracing;
import com.mongodb.MongoClientSettings;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoClientSettingsBuilderCustomizer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.mongodb.TraceMongoDbAutoConfiguration;
import org.springframework.cloud.sleuth.brave.instrument.mongodb.TraceMongoClientSettingsBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingClass(value={"com.mongodb.reactivestreams.client.MongoClient"})
@ConditionalOnBean(value={Tracing.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class, TraceMongoDbAutoConfiguration.class})
@AutoConfigureBefore(value={MongoAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.mongodb.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={MongoClientSettings.Builder.class, MongoDBTracing.class})
@Deprecated
public class BraveMongoDbAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={TraceMongoClientSettingsBuilderCustomizer.class, org.springframework.cloud.sleuth.instrument.mongodb.TraceMongoClientSettingsBuilderCustomizer.class})
    MongoClientSettingsBuilderCustomizer braveTraceMongoClientSettingsBuilderCustomizer(Tracing tracing) {
        return new TraceMongoClientSettingsBuilderCustomizer(tracing);
    }
}

