/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanAndScope;
import org.springframework.cloud.sleuth.Tracer;

public class ThreadLocalSpan {
    private static final Log log = LogFactory.getLog(ThreadLocalSpan.class);
    private final ThreadLocal<SpanAndScope> threadLocalSpan = new ThreadLocal();
    private final Deque<SpanAndScope> spans = new LinkedBlockingDeque<SpanAndScope>();
    private final Tracer tracer;

    public ThreadLocalSpan(Tracer tracer) {
        this.tracer = tracer;
    }

    public void set(Span span) {
        Tracer.SpanInScope spanInScope = this.tracer.withSpan(span);
        SpanAndScope newSpanAndScope = new SpanAndScope(span, spanInScope);
        SpanAndScope scope = this.threadLocalSpan.get();
        if (scope != null) {
            this.spans.addFirst(scope);
        }
        this.threadLocalSpan.set(newSpanAndScope);
    }

    public SpanAndScope get() {
        return this.threadLocalSpan.get();
    }

    public void remove() {
        block4: {
            this.threadLocalSpan.remove();
            if (this.spans.isEmpty()) {
                return;
            }
            try {
                SpanAndScope span = this.spans.removeFirst();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Took span [" + span + "] from thread local"));
                }
                this.threadLocalSpan.set(span);
            }
            catch (NoSuchElementException ex) {
                if (!log.isTraceEnabled()) break block4;
                log.trace((Object)"Failed to remove a span from the queue", (Throwable)ex);
            }
        }
    }
}

