/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.skipper.PackageDeleteException;
import org.springframework.cloud.skipper.ReleaseNotFoundException;
import org.springframework.cloud.skipper.ReleaseUpgradeException;
import org.springframework.cloud.skipper.SkipperException;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class SkipperClientResponseErrorHandler
extends DefaultResponseErrorHandler {
    private ObjectMapper objectMapper;

    public SkipperClientResponseErrorHandler(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must be set");
        this.objectMapper = objectMapper;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        String exceptionClazz = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String body = new String(this.getResponseBody(response));
            Map parsed = (Map)this.objectMapper.readValue(body, Map.class);
            map.putAll(parsed);
            exceptionClazz = (String)map.get("exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ObjectUtils.nullSafeEquals(exceptionClazz, (Object)ReleaseNotFoundException.class.getName())) {
            this.handleReleaseNotFoundException(map);
        } else if (ObjectUtils.nullSafeEquals(exceptionClazz, (Object)PackageDeleteException.class.getName())) {
            this.handlePackageDeleteException(map);
        } else if (ObjectUtils.nullSafeEquals(exceptionClazz, (Object)ReleaseUpgradeException.class.getName())) {
            this.handleReleaseUpgradeException(map);
        } else if (ObjectUtils.nullSafeEquals(exceptionClazz, (Object)SkipperException.class.getName())) {
            this.handleSkipperException(map);
        }
        super.handleError(response);
    }

    private void handleReleaseNotFoundException(Map<String, String> map) {
        String releaseName = map.get("releaseName");
        Integer releaseVersion = null;
        if (map.containsKey("releaseVersion")) {
            try {
                releaseVersion = Integer.parseInt(map.get("releaseVersion"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtils.hasText((String)releaseName)) {
            if (releaseVersion != null) {
                throw new ReleaseNotFoundException(releaseName, releaseVersion.intValue());
            }
            throw new ReleaseNotFoundException(releaseName);
        }
    }

    private void handleReleaseUpgradeException(Map<String, String> map) {
        String message = map.get("message");
        throw new ReleaseUpgradeException(StringUtils.hasText((String)message) ? message : "");
    }

    private void handlePackageDeleteException(Map<String, String> map) {
        String message = map.get("message");
        throw new PackageDeleteException(StringUtils.hasText((String)message) ? message : "");
    }

    private void handleSkipperException(Map<String, String> map) {
        String message = map.get("message");
        throw new SkipperException(StringUtils.hasText((String)message) ? message : "");
    }
}

